<?php
ini_set('session.gc_maxlifetime', 2592000);
session_set_cookie_params(2592000);
session_start();
require 'db.php';

if (isset($_GET['logout'])) {
    unset($_SESSION['admin_id']);
    session_regenerate_id(true);
    header("Location: admin_login.php");
    exit;
}

// If no admin users exist, allow bootstrap creation
$count = (int)$pdo->query("SELECT COUNT(*) FROM admin")->fetchColumn();
$bootstrap = $count === 0;
$msg = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($bootstrap) {
        $hash = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("INSERT INTO admin (username, password_hash) VALUES (?,?)");
        $stmt->execute([$_POST['username'], $hash]);
        $msg = "Admin created. Please log in.";
        $bootstrap = false;
    } else {
        $stmt = $pdo->prepare("SELECT * FROM admin WHERE username=?");
        $stmt->execute([$_POST['username']]);
        $admin = $stmt->fetch(PDO::FETCH_ASSOC);
        if ($admin && password_verify($_POST['password'], $admin['password_hash'])) {
            $_SESSION['admin_id'] = $admin['id'];
            header("Location: admin_panel.php");
            exit;
        } else {
            $msg = "Invalid username or password";
        }
    }
}
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Admin Login</title>
  <link rel="stylesheet" href="assets/css/styles.css">
</head>
<body>
  <main class="container">
    <div class="card" style="max-width:520px;margin:40px auto">
      <h1><?php echo $bootstrap ? 'Create First Admin' : 'Admin Login'; ?></h1>
      <div class="hr"></div>
      <form method="post">
        <label>Username</label>
        <input class="input" type="text" name="username" required>
        <label>Password</label>
        <input class="input" type="password" name="password" required>
        <button class="btn block" type="submit"><?php echo $bootstrap ? 'Create Admin' : 'Login'; ?></button>
      </form>
      <?php if ($msg): ?><p class="badge <?php echo ($count===0)?'accepted':'cancelled'; ?>" style="margin-top:10px"><?php echo htmlspecialchars($msg); ?></p><?php endif; ?>
    </div>
  </main>
</body>
</html>