<?php
session_start();
require 'db.php';
require 'lib/phpqrcode.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

// ------------------------
// Generate Business Card QR (3x7 format)
// ------------------------
function generateBusinessCard($link, $id, $logoPath = "propane.png", $phone = "07508343802") {
    ob_start();
    QRcode::png($link, null, QR_ECLEVEL_L, 6);
    $qrRaw = ob_get_clean();
    $qrImg = imagecreatefromstring($qrRaw);

    $cardW = 250;
    $cardH = 350;
    $card = imagecreatetruecolor($cardW, $cardH);

    // Colors
    $white = imagecolorallocate($card, 255, 255, 255);
    $black = imagecolorallocate($card, 0, 0, 0);
    $gray  = imagecolorallocate($card, 100, 100, 100);
    $blue  = imagecolorallocate($card, 30, 60, 114);
    $lightBlue = imagecolorallocate($card, 232, 240, 254);

    // Gradient background
    for($i = 0; $i < $cardH; $i++) {
        $colorRatio = $i / $cardH;
        $r = 255 - (255 - 230) * $colorRatio;
        $g = 255 - (255 - 240) * $colorRatio;
        $b = 255 - (255 - 255) * $colorRatio;
        $lineColor = imagecolorallocate($card, $r, $g, $b);
        imageline($card, 0, $i, $cardW, $i, $lineColor);
    }

    // Border
    $borderWidth = 16;
    for($i = 0; $i < $borderWidth; $i++) {
        imagerectangle($card, $i, $i, $cardW-1-$i, $cardH-1-$i, $blue);
    }

    // ID at top
    $fontSize = 20;
    $idText = "ID: " . $id;
    $idX = ($cardW - imagefontwidth($fontSize) * strlen($idText)) / 2;
    $idY = 25;
    $idBgWidth = imagefontwidth($fontSize) * strlen($idText) + 20;
    $idBgHeight = imagefontheight($fontSize) + 10;
    imagefilledrectangle($card, $idX - 10, $idY - 5, $idX + $idBgWidth - 10, $idY + $idBgHeight - 5, $blue);
    imagestring($card, $fontSize, $idX, $idY, $idText, $white);

    // QR code
    $qrSize = min($cardW * 0.7, 250);
    $qrX = ($cardW - $qrSize) / 2;
    $qrY = $idY + 50;
    imagefilledrectangle($card, $qrX - 10, $qrY - 10, $qrX + $qrSize + 10, $qrY + $qrSize + 10, $lightBlue);
    imagerectangle($card, $qrX - 10, $qrY - 10, $qrX + $qrSize + 10, $qrY + $qrSize + 10, $blue);
    imagecopyresampled($card, $qrImg, $qrX, $qrY, 0, 0, $qrSize, $qrSize, imagesx($qrImg), imagesy($qrImg));

    // Divider
    $dividerY = $qrY + $qrSize + 40;
    imageline($card, 30, $dividerY, $cardW - 30, $dividerY, $blue);
    imageline($card, 30, $dividerY + 1, $cardW - 30, $dividerY + 1, $lightBlue);

    // Phone & company
    $phoneText = "☎ " . $phone;
    $phoneX = ($cardW - imagefontwidth(2) * strlen($phoneText)) / 2;
    $phoneY = $dividerY + 20;
    imagestring($card, 2, $phoneX, $phoneY, $phoneText, $gray);

    $companyText = "GhazQR Solutions";
    $companyX = ($cardW - imagefontwidth(2) * strlen($companyText)) / 2;
    $companyY = $phoneY + 25;
    imagestring($card, 2, $companyX, $companyY, $companyText, $blue);

    ob_start();
    imagepng($card);
    $final = ob_get_clean();
    imagedestroy($qrImg);
    imagedestroy($card);
    return $final;
}

// ------------------------
// Handle POST
// ------------------------
if($_SERVER['REQUEST_METHOD']==='POST'){
    if(isset($_POST['add_user'])){
        $count = max(1,intval($_POST['count'] ?? 1));
        for($i=1;$i<=$count;$i++){
            $token = bin2hex(random_bytes(16));
            $expires = date('Y-m-d H:i:s', strtotime('+1 years'));
            // user starts inactive, activates on first scan
            $stmt = $pdo->prepare("INSERT INTO users (name, phone, login_token, login_token_expires, active) VALUES (?,?,?,?,0)");
            $stmt->execute(["","","$token","$expires"]);
        }
        header("Location: admin_users.php"); exit;
    }

    if(isset($_POST['extend_token'])){
        $expires = date('Y-m-d H:i:s', strtotime('+1 years'));
        $stmt = $pdo->prepare("UPDATE users SET login_token_expires=? WHERE id=?");
        $stmt->execute([$expires,$_POST['user_id']]);
        header("Location: admin_users.php"); exit;
    }

    if(isset($_POST['toggle_active'])){
        $stmt = $pdo->prepare("UPDATE users SET active=? WHERE id=?");
        $stmt->execute([$_POST['active'],$_POST['user_id']]);
        header("Location: admin_users.php"); exit;
    }

    if(isset($_POST['delete_user'])){
        $stmt = $pdo->prepare("DELETE FROM users WHERE id=?");
        $stmt->execute([$_POST['user_id']]);
        header("Location: admin_users.php"); exit;
    }

    if(isset($_POST['download_qr_range'])){
        $from = intval($_POST['from_id']);
        $to = intval($_POST['to_id']);
        if($from>0 && $to >= $from){
            $stmt = $pdo->prepare("SELECT * FROM users WHERE id BETWEEN ? AND ?");
            $stmt->execute([$from,$to]);
            $usersToDownload = $stmt->fetchAll(PDO::FETCH_ASSOC);
            if($usersToDownload){
                $zipFile = tempnam(sys_get_temp_dir(),'qrzip_').".zip";
                $zip = new ZipArchive();
                $zip->open($zipFile,ZipArchive::CREATE | ZipArchive::OVERWRITE);
                foreach($usersToDownload as $u){
                    $link = 'https://diyari-iq.com/GhazQR/login.php?token='.$u['login_token'];
                    $card = generateBusinessCard($link,$u['id'],"propane.png","7500000000");
                    $zip->addFromString("Card_".$u['id'].".png",$card);
                }
                $zip->close();
                header('Content-Type: application/zip');
                header('Content-Disposition: attachment; filename="QRs_'.$from.'-'.$to.'.zip"');
                header('Content-Length: '.filesize($zipFile));
                readfile($zipFile);
                unlink($zipFile);
                exit;
            }
        }
    }

    if(isset($_POST['download_single_qr'])){
        $user_id = intval($_POST['user_id']);
        $stmt = $pdo->prepare("SELECT * FROM users WHERE id=?");
        $stmt->execute([$user_id]);
        $u = $stmt->fetch(PDO::FETCH_ASSOC);
        if($u){
            $link = 'https://diyari-iq.com/GhazQR/login.php?token='.$u['login_token'];
            $card = generateBusinessCard($link, $u['id'], "propane.png", "7500000000");
            header('Content-Type: image/png');
            header('Content-Disposition: attachment; filename="Card_'.$u['id'].'.png"');
            echo $card;
            exit;
        }
    }
}

// ------------------------
// Fetch Users
// ------------------------
$search = $_GET['search'] ?? '';
$activeFilter = $_GET['active'] ?? '';
$expiredFilter = $_GET['expired'] ?? '';
$sort = $_GET['sort'] ?? 'id';
$order = $_GET['order'] ?? 'DESC';
$validSort = ['id','name','login_token_expires','active'];
if(!in_array($sort,$validSort)) $sort='id';
$order = strtoupper($order)=='ASC'?'ASC':'DESC';

$query = "SELECT u.*, a.name AS area_name FROM users u LEFT JOIN areas a ON u.area_id=a.id WHERE CONCAT(u.id,' ',u.name,' ',u.phone,' ',IFNULL(u.address,'')) LIKE ?";
$params = ["%$search%"];
if($activeFilter==='0' || $activeFilter==='1'){ $query .= " AND u.active=?"; $params[] = $activeFilter; }
if($expiredFilter==='1'){ $query .= " AND u.login_token_expires<?"; $params[] = date('Y-m-d H:i:s'); }
elseif($expiredFilter==='0'){ $query .= " AND u.login_token_expires>=?"; $params[] = date('Y-m-d H:i:s'); }
$query .= " ORDER BY $sort $order";
$stmt = $pdo->prepare($query);
$stmt->execute($params);
$users = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
<meta charset="utf-8">
<title>Manage Users</title>
<link rel="stylesheet" href="assets/css/styles.css">
<style>
.table input { width: 100%; padding:4px; }
.qr-img { max-width:80px; margin-top:5px; display:block; }
.copy-btn { margin-top:3px; font-size:12px; padding:2px 6px; }
.expired { color:red; font-weight:bold; }
</style>
</head>
<body>
<div class="header">
  <div class="header-inner container">
    <div class="brand"><div class="logo"></div><h1>Users</h1></div>
    <a class="btn secondary" href="admin_panel.php">Dashboard</a>
  </div>
</div>
<main class="container">

<!-- Add Users -->
<div class="card">
<h2>Add User(s)</h2>
<div class="hr"></div>
<form method="post" style="display:flex;gap:10px;flex-wrap:wrap">
<input class="input" type="number" name="count" placeholder="Count" min="1" value="1">
<button class="btn" type="submit" name="add_user">Create Blank Accounts</button>
</form>
<p style="font-size:12px;color:gray;margin-top:6px">Accounts are blank & inactive. They activate on first scan.</p>
</div>

<!-- Filter / Sort -->
<div class="card" style="margin-top:16px">
<h2>Filter / Sort</h2>
<form method="get" style="display:flex;gap:10px;flex-wrap:wrap;align-items:center">
<input class="input" name="search" value="<?php echo htmlspecialchars($search); ?>" placeholder="Search">
<select name="active">
<option value="">All Active</option>
<option value="1" <?php if($activeFilter==='1') echo 'selected'; ?>>Active</option>
<option value="0" <?php if($activeFilter==='0') echo 'selected'; ?>>Inactive</option>
</select>
<select name="expired">
<option value="">All Expires</option>
<option value="1" <?php if($expiredFilter==='1') echo 'selected'; ?>>Expired</option>
<option value="0" <?php if($expiredFilter==='0') echo 'selected'; ?>>Not Expired</option>
</select>
<select name="sort">
<option value="id" <?php if($sort=='id') echo 'selected'; ?>>ID</option>
<option value="name" <?php if($sort=='name') echo 'selected'; ?>>Name</option>
<option value="login_token_expires" <?php if($sort=='login_token_expires') echo 'selected'; ?>>Expires</option>
<option value="active" <?php if($sort=='active') echo 'selected'; ?>>Active</option>
</select>
<select name="order">
<option value="DESC" <?php if($order=='DESC') echo 'selected'; ?>>DESC</option>
<option value="ASC" <?php if($order=='ASC') echo 'selected'; ?>>ASC</option>
</select>
<button class="btn" type="submit">Apply</button>
<a class="btn secondary" href="admin_users.php">Reset</a>
</form>
</div>

<!-- Download QR Range -->
<div class="card" style="margin-top:16px">
<h2>Download Cards by Range</h2>
<form method="post" style="display:flex;gap:10px;flex-wrap:wrap">
<input class="input" type="number" name="from_id" placeholder="From ID" required>
<input class="input" type="number" name="to_id" placeholder="To ID" required>
<button class="btn" type="submit" name="download_qr_range">Download ZIP</button>
</form>
</div>

<!-- Users List -->
<div class="card" style="margin-top:16px">
<h2>Users List</h2>
<div class="hr"></div>
<table class="table">
<thead>
<tr>
<th>ID</th><th>Name</th><th>Phone</th><th>Link / QR</th><th>Expires</th><th>Status</th><th>Actions</th>
</tr>
</thead>
<tbody>
<?php foreach($users as $u):
$link = 'https://diyari-iq.com/GhazQR/login.php?token='.$u['login_token'];
ob_start(); QRcode::png($link,null,QR_ECLEVEL_L,3); $qrImage = base64_encode(ob_get_clean());
$expired = (strtotime($u['login_token_expires']) < time());
?>
<tr>
<td><?php echo $u['id'];?></td>
<td><?php echo htmlspecialchars($u['name']);?></td>
<td><?php echo htmlspecialchars($u['phone']);?></td>
<td>
<input id="link_<?php echo $u['id'];?>" type="text" value="<?php echo $link;?>" readonly>
<button class="copy-btn" onclick="navigator.clipboard.writeText(document.getElementById('link_<?php echo $u['id'];?>').value)">Copy</button>
<img class="qr-img" src="data:image/png;base64,<?php echo $qrImage;?>" alt="QR">
</td>
<td class="<?php echo $expired?'expired':'';?>"><?php echo $u['login_token_expires'];?></td>
<td>
<?php 
if($expired){
    echo '<span class="expired">Expired</span>';
} elseif($u['active']==0){
    echo 'Inactive (Not yet scanned)';
} else {
    echo 'Active';
}
?>
</td>
<td style="display:flex;gap:5px;flex-wrap:wrap">
<form method="post"><input type="hidden" name="user_id" value="<?php echo $u['id'];?>"><button class="btn" type="submit" name="extend_token">Extend 1 yr</button></form>
<form method="post"><input type="hidden" name="user_id" value="<?php echo $u['id'];?>"><input type="hidden" name="active" value="<?php echo $u['active']?0:1;?>"><button class="btn secondary" type="submit" name="toggle_active"><?php echo $u['active']?'Deactivate':'Activate';?></button></form>
<form method="post"><input type="hidden" name="user_id" value="<?php echo $u['id'];?>"><button class="btn secondary" type="submit" name="download_single_qr">Download Card</button></form>
<form method="post" onsubmit="return confirm('Delete this user?')"><input type="hidden" name="user_id" value="<?php echo $u['id'];?>"><button class="btn danger" type="submit" name="delete_user">Delete</button></form>
</td>
</tr>
<?php endforeach;?>
</tbody>
</table>
</div>

</main>
<div class="footer">© <?php echo date('Y');?> Propane Service</div>
</body>
</html>
