async function postJSON(url, data){
  const res = await fetch(url, {
    method:'POST',
    headers:{'Content-Type':'application/x-www-form-urlencoded'},
    body: new URLSearchParams(data)
  });
  if(!res.ok) throw new Error('Network error');
  return res.text();
}
function $(sel, root=document){ return root.querySelector(sel); }
function $all(sel, root=document){ return Array.from(root.querySelectorAll(sel)); }
async function getGPSInto(latInputSel, lngInputSel, statusSel){
  const latI = document.querySelector(latInputSel);
  const lngI = document.querySelector(lngInputSel);
  const status = statusSel ? document.querySelector(statusSel) : null;
  if(!navigator.geolocation){ if(status) status.textContent='Geolocation not supported.'; return; }
  if(status) status.textContent='Getting location...';
  navigator.geolocation.getCurrentPosition(
    pos=>{
      latI.value = pos.coords.latitude.toFixed(6);
      lngI.value = pos.coords.longitude.toFixed(6);
      if(status) status.textContent='Location captured ✓';
    },
    err=>{ if(status) status.textContent = 'Location error: ' + err.message; },
    {enableHighAccuracy:true, timeout:10000, maximumAge:0}
  );
}
function startPoll(fn, ms=4000){ fn(); return setInterval(fn, ms); }
function enhanceRows(){
  $all('tr[data-detail]').forEach(tr=>{
    tr.addEventListener('click',()=>{ alert(tr.getAttribute('data-detail')); });
  });
}
document.addEventListener('DOMContentLoaded', enhanceRows);
