<?php
session_start();
require 'db.php';
require 'lib/phpqrcode.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

$token = $_GET['token'] ?? '';
$id = $_GET['id'] ?? '';

if (!$token || !$id) {
    die('Invalid request');
}

// Generate the login link
$link = "https://diyari-iq.com/GhazQR/login.php?token=" . $token;

// Temp file for QR
$tmpFile = tempnam(sys_get_temp_dir(), 'qr_');

// Generate QR code
QRcode::png($link, $tmpFile, QR_ECLEVEL_L, 6);

// Load QR image
$qr = imagecreatefrompng($tmpFile);
unlink($tmpFile);

$qrWidth = imagesx($qr);
$qrHeight = imagesy($qr);

// Create new image with padding below
$padding = 80; // space for text
$newHeight = $qrHeight + $padding;
$final = imagecreatetruecolor($qrWidth, $newHeight);

// White background
$white = imagecolorallocate($final, 255, 255, 255);
$black = imagecolorallocate($final, 0, 0, 0);
imagefill($final, 0, 0, $white);

// Copy QR on top
imagecopy($final, $qr, 0, 0, 0, 0, $qrWidth, $qrHeight);
imagedestroy($qr);

// Text settings
$text = "ID: " . $id;
$fontSize = 18;
$fontFile = __DIR__ . '/lib/arial.ttf'; // <-- make sure this font file exists

// Calculate text width/center
$bbox = imagettfbbox($fontSize, 0, $fontFile, $text);
$textWidth = $bbox[2] - $bbox[0];
$textX = ($qrWidth - $textWidth) / 2;
$textY = $qrHeight + 50; // vertical position inside padding

// Draw text
imagettftext($final, $fontSize, 0, $textX, $textY, $black, $fontFile, $text);

// Output final image
header('Content-Type: image/png');
header('Content-Disposition: attachment; filename="user_'.$id.'_qr.png"');
imagepng($final);
imagedestroy($final);
exit;
