<?php
ini_set('session.gc_maxlifetime', 2592000);
session_set_cookie_params(2592000);
session_start();
require 'db.php';

if (isset($_GET['logout'])) {
    unset($_SESSION['driver_id']);
    session_regenerate_id(true);
    header("Location: driver_login.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("SELECT * FROM drivers WHERE username=?");
    $stmt->execute([$_POST['username']]);
    $driver = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($driver && password_verify($_POST['password'], $driver['password_hash'])) {
        $_SESSION['driver_id'] = $driver['id'];
        header("Location: driver_panel.php");
        exit;
    } else {
        $error = "Invalid username or password";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- makes it mobile-friendly -->
  <title>Driver Login</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <style>
    body { background:#0f172a; color:#e2e8f0; font-family:system-ui,sans-serif; margin:0; }
    .container { max-width:480px; margin:60px auto; padding:0 16px; }
    .card { background:#1e293b; border-radius:16px; padding:24px; box-shadow:0 6px 16px rgba(0,0,0,.4); }
    h1 { margin-top:0; font-weight:600; font-size:22px; }
    .hr { border-bottom:1px solid #334155; margin:16px 0; }
    label { display:block; margin-top:12px; margin-bottom:6px; font-size:14px; color:#cbd5e1; }
    .input { width:100%; padding:12px; border-radius:8px; border:1px solid #334155; background:#0f172a; color:#e2e8f0; font-size:15px; }
    .input:focus { outline:none; border-color:#3b82f6; }
    .btn.block { width:100%; margin-top:20px; padding:14px; border-radius:10px; background:#3b82f6; color:#fff; border:none; font-size:16px; cursor:pointer; transition:.3s; }
    .btn.block:hover { background:#2563eb; }
    .badge { display:inline-block; padding:8px 12px; border-radius:8px; font-size:14px; margin-top:12px; }
    .badge.cancelled { background:#dc2626; color:#fff; }

    /* Responsive tweaks */
    @media (max-width: 600px) {
      .container { margin:30px auto; padding:0 12px; }
      .card { padding:20px; }
      h1 { font-size:20px; }
      .btn.block { font-size:15px; padding:12px; }
    }
    @media (min-width: 1024px) {
      .container { max-width:500px; }
    }
  </style>
</head>
<body>
  <main class="container">
    <div class="card">
      <h1>Driver Login</h1>
      <div class="hr"></div>
      <form method="post">
        <label>Username</label>
        <input class="input" type="text" name="username" required>
        <label>Password</label>
        <input class="input" type="password" name="password" required>
        <button class="btn block" type="submit">Login</button>
      </form>
      <?php if (!empty($error)): ?>
        <p class="badge cancelled"><?php echo htmlspecialchars($error); ?></p>
      <?php endif; ?>
    </div>
  </main>
</body>
</html>
