<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit;
}

if (!isset($_GET['order_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Order ID required']);
    exit;
}

$order_id = (int)$_GET['order_id'];
$user_id = $_SESSION['user_id'];

// Verify the order belongs to the user and get driver location
$stmt = $pdo->prepare("
    SELECT d.gps_lat, d.gps_lng, d.last_location_update 
    FROM orders o 
    JOIN drivers d ON o.driver_id = d.id 
    WHERE o.id = ? AND o.user_id = ? AND o.status = 'accepted'
");
$stmt->execute([$order_id, $user_id]);
$driver_data = $stmt->fetch(PDO::FETCH_ASSOC);

header('Content-Type: application/json');
if ($driver_data && $driver_data['gps_lat'] && $driver_data['gps_lng']) {
    echo json_encode([
        'success' => true,
        'driver_lat' => $driver_data['gps_lat'],
        'driver_lng' => $driver_data['gps_lng'],
        'last_update' => date('Y-m-d H:i', strtotime($driver_data['last_location_update']))
    ]);
} else {
    echo json_encode(['success' => false, 'message' => 'Driver location not available']);
}
?>