<?php
session_start();
require 'db.php';

if (!isset($_GET['token']) || empty($_GET['token'])) {
    die("Invalid link");
}

$token = urldecode($_GET['token']);

// Fetch user by token only
$stmt = $pdo->prepare("SELECT * FROM users WHERE login_token=? LIMIT 1");
$stmt->execute([$token]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user) {
    die("Invalid link");
}

// If token already expired → deny
if (strtotime($user['login_token_expires']) < time()) {
    die("Expired link");
}

// If first login (active=0) → extend license for 2 years & set active=1
if ((int)$user['active'] === 0) {
    $newExpiry = date('Y-m-d H:i:s', strtotime('+2 years'));
    $stmt = $pdo->prepare("UPDATE users SET active=1, login_token_expires=? WHERE id=?");
    $stmt->execute([$newExpiry, $user['id']]);
    $user['active'] = 1;
    $user['login_token_expires'] = $newExpiry;
}

// Normal login
$_SESSION['user_id'] = $user['id'];
session_regenerate_id(true);

header("Location: user_dashboard.php");
exit;
