<?php
session_start();
require 'db.php';
require 'lib/phpqrcode.php';

if (!isset($_SESSION['admin_id'])) {
    header("Location: admin_login.php");
    exit;
}

$token = $_GET['token'] ?? '';
$id = $_GET['id'] ?? '';

if (!$token || !$id) {
    die('Invalid request');
}

// Generate the login link
$link = "https://diyari-iq.com/propane/login.php?token=" . $token;

// Temporary QR file
$tmpFile = tempnam(sys_get_temp_dir(), 'qr');

// Generate QR (only link encoded)
QRcode::png($link, $tmpFile, QR_ECLEVEL_L, 6);

// Open QR image with GD
$im = imagecreatefrompng($tmpFile);
unlink($tmpFile); // remove temp file

// Allocate color for text
$black = imagecolorallocate($im, 0, 0, 0);
$font = 5; // built-in font size
$imgWidth = imagesx($im);
$imgHeight = imagesy($im);
$text = "ID: " . $id;

// Add extra space below QR to fit the text
$newHeight = $imgHeight + 20;
$newIm = imagecreatetruecolor($imgWidth, $newHeight);

// White background
$white = imagecolorallocate($newIm, 255, 255, 255);
imagefill($newIm, 0, 0, $white);

// Copy QR into new image
imagecopy($newIm, $im, 0, 0, 0, 0, $imgWidth, $imgHeight);

// Add text at bottom center
imagestring(
    $newIm,
    $font,
    ($imgWidth - strlen($text) * imagefontwidth($font)) / 2,
    $imgHeight + 3,
    $text,
    $black
);

// Output final PNG for download
ob_start();
imagepng($newIm);
$imageString = ob_get_clean();

imagedestroy($im);
imagedestroy($newIm);

// Send headers to force download
header('Content-Type: image/png');
header('Content-Disposition: attachment; filename="user_'.$id.'_qr.png"');
header('Content-Length: ' . strlen($imageString));

echo $imageString;
exit;
