<?php
session_start();
require 'db.php';

if (!isset($_SESSION['driver_id'])) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Not authorized']);
    exit;
}

$driver_id = $_SESSION['driver_id'];
$lat = $_POST['lat'] ?? null;
$lng = $_POST['lng'] ?? null;

if (!$lat || !$lng) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Missing location data']);
    exit;
}

try {
    $stmt = $pdo->prepare("UPDATE drivers SET gps_lat = ?, gps_lng = ?, last_location_update = NOW() WHERE id = ?");
    $stmt->execute([$lat, $lng, $driver_id]);
    
    header('Content-Type: application/json');
    echo json_encode(['success' => true, 'message' => 'Location updated']);
} catch (Exception $e) {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
?>