<?php
session_start();
require 'db.php';
require 'lang.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Create a new order for this user with user's area
    $stmt = $pdo->prepare("INSERT INTO orders (user_id, area_id, qty)
                           SELECT id, area_id, 1 FROM users WHERE id = ?");
    $stmt->execute([$user_id]);
    $message = "Your order has been placed!";
}

// Set direction based on language
$dir = ($lang == 'ar') ? 'rtl' : 'ltr';
?>
<!DOCTYPE html>
<html dir="<?php echo $dir; ?>">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title><?php echo t('dashboard'); ?> — Propane Service</title>
  <style>
    :root {
      --primary: #4cc9f0;
      --secondary: #4895ef;
      --accent: #4361ee;
      --success: #4ade80;
      --danger: #f75555;
      --warning: #f59e0b;
      --light: #ffffff;
      --dark: #1e293b;
      --gray: #64748b;
      --light-gray: #f1f5f9;
      --border-radius: 12px;
      --box-shadow: 0 10px 25px rgba(0,0,0,0.08);
      --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
      --gradient: linear-gradient(135deg, #4cc9f0 0%, #4895ef 50%, #4361ee 100%);
    }

    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Segoe UI', system-ui, -apple-system, sans-serif;
    }

    body {
      background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
      min-height: 100vh;
      padding: 0;
      color: #334155;
      direction: <?php echo $dir; ?>;
      line-height: 1.6;
    }

    /* Modern Compact Header */
    .header {
      background: var(--light);
      box-shadow: 0 4px 20px rgba(76, 201, 240, 0.15);
      padding: 8px 5%;
      display: flex;
      justify-content: space-between;
      align-items: center;
      flex-wrap: wrap;
      gap: 8px;
      width: 100%;
      position: sticky;
      top: 0;
      z-index: 1000;
      min-height: 52px;
      border-bottom: 1px solid rgba(76, 201, 240, 0.2);
      backdrop-filter: blur(10px);
      animation: slideDown 0.5s ease-out;
    }

    @keyframes slideDown {
      from {
        transform: translateY(-100%);
        opacity: 0;
      }
      to {
        transform: translateY(0);
        opacity: 1;
      }
    }

    .brand {
      display: flex;
      align-items: center;
      gap: 10px;
      flex-shrink: 0;
    }

    .logo {
      width: 28px;
      height: 28px;
      background: var(--gradient);
      border-radius: 8px;
      display: flex;
      align-items: center;
      justify-content: center;
      color: white;
      font-weight: bold;
      flex-shrink: 0;
      font-size: 0.8rem;
      box-shadow: 0 4px 12px rgba(76, 201, 240, 0.3);
      animation: pulse 2s infinite;
    }

    @keyframes pulse {
      0%, 100% { transform: scale(1); }
      50% { transform: scale(1.05); }
    }

    h1, h2 {
      color: var(--accent);
      word-wrap: break-word;
    }

    h1 {
      font-size: 1.2rem;
      margin: 0;
      font-weight: 700;
      background: var(--gradient);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }

    h2 {
      font-size: 1.3rem;
      font-weight: 600;
    }

    .language-switcher {
      display: flex;
      gap: 4px;
      flex-wrap: wrap;
      background: var(--light-gray);
      padding: 2px;
      border-radius: 8px;
    }

    .lang-btn {
      padding: 4px 8px;
      border: none;
      border-radius: 6px;
      background: transparent;
      color: var(--gray);
      cursor: pointer;
      transition: var(--transition);
      text-decoration: none;
      font-size: 0.75rem;
      flex-shrink: 0;
      font-weight: 500;
    }

    .lang-btn.active {
      background: var(--primary);
      color: white;
      box-shadow: 0 2px 8px rgba(76, 201, 240, 0.3);
    }

    .lang-btn:hover {
      background: var(--primary);
      color: white;
      transform: translateY(-1px);
    }

    .btn {
      display: inline-flex;
      align-items: center;
      justify-content: center;
      padding: 6px 12px;
      background: var(--gradient);
      color: white;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      text-decoration: none;
      font-weight: 600;
      transition: var(--transition);
      box-shadow: 0 4px 12px rgba(76, 201, 240, 0.3);
      text-align: center;
      white-space: nowrap;
      min-height: 32px;
      font-size: 0.8rem;
      position: relative;
      overflow: hidden;
    }

    .btn::before {
      content: '';
      position: absolute;
      top: 0;
      left: -100%;
      width: 100%;
      height: 100%;
      background: linear-gradient(90deg, transparent, rgba(255,255,255,0.3), transparent);
      transition: left 0.5s;
    }

    .btn:hover::before {
      left: 100%;
    }

    .btn:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(76, 201, 240, 0.4);
    }

    .btn.secondary {
      background: var(--light);
      color: var(--primary);
      border: 1.5px solid var(--primary);
      box-shadow: none;
    }

    .btn.secondary:hover {
      background: var(--primary);
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 4px 12px rgba(76, 201, 240, 0.3);
    }

    .container {
      width: 100%;
      max-width: 100%;
      margin: 0 auto;
      padding: 20px 5%;
    }

    .card {
      background: var(--light);
      border-radius: var(--border-radius);
      box-shadow: var(--box-shadow);
      padding: clamp(20px, 4vw, 30px);
      margin-bottom: 25px;
      overflow: hidden;
      border: 1px solid rgba(76, 201, 240, 0.1);
      animation: fadeInUp 0.6s ease-out;
      position: relative;
    }

    @keyframes fadeInUp {
      from {
        opacity: 0;
        transform: translateY(30px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .card::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      height: 2px;
      background: var(--gradient);
      transform: scaleX(0);
      transition: transform 0.3s ease;
    }

    .card:hover::before {
      transform: scaleX(1);
    }

    .card:hover {
      transform: translateY(-5px);
      box-shadow: 0 15px 30px rgba(76, 201, 240, 0.15);
    }

    .hr {
      height: 1px;
      background: linear-gradient(90deg, transparent, var(--primary), transparent);
      margin: 20px 0;
    }

    .muted {
      color: var(--gray);
      line-height: 1.6;
      font-size: 0.95rem;
    }

    .badge {
      padding: 8px 16px;
      border-radius: 20px;
      font-size: 0.8rem;
      font-weight: 600;
      display: inline-block;
      margin-bottom: 15px;
      animation: slideInRight 0.5s ease-out;
    }

    @keyframes slideInRight {
      from {
        opacity: 0;
        transform: translateX(30px);
      }
      to {
        opacity: 1;
        transform: translateX(0);
      }
    }

    .delivered {
      background: rgba(74, 222, 128, 0.1);
      color: #16a34a;
      border-left: 4px solid var(--success);
    }

    .footer {
      text-align: center;
      padding: 20px;
      color: var(--gray);
      margin-top: 40px;
      background: var(--light);
      border-top: 1px solid rgba(76, 201, 240, 0.2);
      font-size: clamp(0.9rem, 2vw, 1rem);
    }

    /* Header actions - compact */
    .header-actions {
      display: flex;
      align-items: center;
      gap: 8px;
      flex-wrap: wrap;
    }

    .nav-buttons {
      display: flex;
      gap: 6px;
      flex-wrap: wrap;
    }

    /* Main content grid */
    .grid {
      display: grid;
      gap: 25px;
      margin-top: 20px;
    }

    .grid-2 {
      grid-template-columns: repeat(auto-fit, minmax(min(100%, 400px), 1fr));
    }

    /* Propane Image Styles */
    .propane-img {
      max-width: 100%;
      height: auto;
      cursor: pointer;
      transition: var(--transition);
      border-radius: var(--border-radius);
      box-shadow: 0 8px 25px rgba(0,0,0,0.1);
    }

    .propane-img:hover {
      transform: scale(1.05) rotate(2deg);
      box-shadow: 0 12px 35px rgba(76, 201, 240, 0.3);
    }

    .image-container {
      text-align: center;
      margin-top: 20px;
      padding: 20px;
      background: var(--light-gray);
      border-radius: var(--border-radius);
      border: 2px dashed rgba(76, 201, 240, 0.3);
      transition: var(--transition);
    }

    .image-container:hover {
      border-color: var(--primary);
      background: rgba(76, 201, 240, 0.05);
    }

    /* Popup Styles */
    .popup-overlay {
      position: fixed;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: rgba(0, 0, 0, 0.5);
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 2000;
      opacity: 0;
      visibility: hidden;
      transition: var(--transition);
      backdrop-filter: blur(5px);
    }

    .popup-overlay.active {
      opacity: 1;
      visibility: visible;
    }

    .popup-content {
      background: var(--light);
      border-radius: var(--border-radius);
      box-shadow: 0 20px 40px rgba(0,0,0,0.2);
      padding: 30px;
      width: 90%;
      max-width: 500px;
      transform: translateY(-50px) scale(0.9);
      transition: var(--transition);
      text-align: center;
      position: relative;
      border: 1px solid rgba(76, 201, 240, 0.2);
      animation: modalSlideIn 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    @keyframes modalSlideIn {
      from { transform: translateY(-50px) scale(0.9); opacity: 0; }
      to { transform: translateY(0) scale(1); opacity: 1; }
    }

    .popup-overlay.active .popup-content {
      transform: translateY(0) scale(1);
    }

    .popup-close {
      position: absolute;
      top: 15px;
      right: 15px;
      background: rgba(76, 201, 240, 0.1);
      border: none;
      font-size: 1.25rem;
      cursor: pointer;
      color: var(--gray);
      width: 28px;
      height: 28px;
      display: flex;
      align-items: center;
      justify-content: center;
      border-radius: 50%;
      transition: var(--transition);
    }

    .popup-close:hover {
      background: var(--primary);
      color: white;
      transform: rotate(90deg);
    }

    .popup-title {
      color: var(--accent);
      margin-bottom: 15px;
      font-weight: 700;
      background: var(--gradient);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      background-clip: text;
    }

    .popup-message {
      margin-bottom: 25px;
      color: var(--dark);
      line-height: 1.6;
    }

    .popup-buttons {
      display: flex;
      justify-content: center;
      gap: 12px;
      flex-wrap: wrap;
    }

    .popup-btn {
      padding: 10px 20px;
      border: none;
      border-radius: 8px;
      cursor: pointer;
      font-weight: 600;
      transition: var(--transition);
      min-width: 100px;
      font-size: 0.85rem;
    }

    .popup-btn.confirm {
      background: var(--gradient);
      color: white;
      box-shadow: 0 4px 12px rgba(76, 201, 240, 0.3);
    }

    .popup-btn.confirm:hover {
      transform: translateY(-2px);
      box-shadow: 0 6px 20px rgba(76, 201, 240, 0.4);
    }

    .popup-btn.cancel {
      background: var(--light);
      color: var(--primary);
      border: 1.5px solid var(--primary);
    }

    .popup-btn.cancel:hover {
      background: var(--primary);
      color: white;
      transform: translateY(-2px);
    }

    /* Responsive adjustments */
    @media (max-width: 768px) {
      .header {
        padding: 6px 15px;
        gap: 6px;
      }
      
      .brand {
        gap: 8px;
      }
      
      .logo {
        width: 24px;
        height: 24px;
        font-size: 0.7rem;
      }
      
      h1 {
        font-size: 1.1rem;
      }
      
      .header-actions {
        gap: 6px;
      }
      
      .nav-buttons {
        gap: 4px;
      }
      
      .btn {
        padding: 5px 10px;
        font-size: 0.75rem;
        min-height: 28px;
      }
      
      .lang-btn {
        padding: 3px 6px;
        font-size: 0.7rem;
      }
      
      .popup-buttons {
        flex-direction: column;
      }
      
      .popup-btn {
        width: 100%;
      }
      
      .grid-2 {
        grid-template-columns: 1fr;
      }
    }

    @media (max-width: 480px) {
      .header {
        padding: 6px 10px;
        min-height: 48px;
      }
      
      .brand {
        flex-direction: row;
        gap: 6px;
      }
      
      .logo {
        width: 22px;
        height: 22px;
        font-size: 0.65rem;
      }
      
      h1 {
        font-size: 1rem;
      }
      
      .header-actions {
        flex-direction: column;
        align-items: flex-end;
        gap: 4px;
      }
      
      .language-switcher {
        order: -1;
        justify-content: flex-end;
      }
      
      .nav-buttons {
        justify-content: flex-end;
      }
      
      .btn {
        padding: 4px 8px;
        font-size: 0.7rem;
        min-height: 26px;
      }
    }

    @media (max-width: 360px) {
      .header {
        padding: 4px 8px;
      }
      
      .brand {
        gap: 4px;
      }
      
      h1 {
        font-size: 0.9rem;
      }
      
      .nav-buttons {
        flex-direction: column;
        gap: 3px;
        width: 100%;
      }
      
      .nav-buttons .btn {
        width: auto;
        min-width: 100px;
      }
    }

    /* Extra small devices */
    @media (max-width: 320px) {
      .header {
        flex-direction: column;
        align-items: stretch;
        gap: 6px;
        padding: 6px;
      }
      
      .brand {
        justify-content: center;
        text-align: center;
      }
      
      .header-actions {
        align-items: center;
        gap: 6px;
      }
      
      .language-switcher {
        justify-content: center;
        width: 100%;
      }
      
      .nav-buttons {
        justify-content: center;
        width: 100%;
      }
      
      .nav-buttons .btn {
        width: 100%;
        max-width: 180px;
      }
    }
  </style>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      // Add animation to cards
      const cards = document.querySelectorAll('.card');
      cards.forEach((card, index) => {
        card.style.animationDelay = `${index * 0.2}s`;
      });

      // Popup functionality
      const propaneImage = document.getElementById('propane-image');
      const popupOverlay = document.getElementById('popup-overlay');
      const closePopup = document.getElementById('close-popup');
      const cancelOrder = document.getElementById('cancel-order');
      const confirmOrder = document.getElementById('confirm-order');
      const orderForm = document.getElementById('order-form');

      // Open popup when clicking propane image
      propaneImage.addEventListener('click', function() {
        popupOverlay.classList.add('active');
      });

      // Close popup when clicking X or cancel
      closePopup.addEventListener('click', closePopupFunc);
      cancelOrder.addEventListener('click', closePopupFunc);

      // Confirm order
      confirmOrder.addEventListener('click', function() {
        // Submit the form
        orderForm.submit();
      });

      // Close popup when clicking outside content
      popupOverlay.addEventListener('click', function(e) {
        if (e.target === popupOverlay) {
          closePopupFunc();
        }
      });

      function closePopupFunc() {
        popupOverlay.classList.remove('active');
      }

      // Add animation to propane image
      const imageContainer = document.querySelector('.image-container');
      if (imageContainer) {
        imageContainer.addEventListener('mouseenter', function() {
          this.style.transform = 'scale(1.02)';
        });
        
        imageContainer.addEventListener('mouseleave', function() {
          this.style.transform = 'scale(1)';
        });
      }
    });
  </script>
</head>
<body>

<!-- Modern Compact Header -->
<div class="header">
  <div class="brand">
    <div class="logo">PS</div>
    <h1><?php echo t('dashboard'); ?></h1>
  </div>
  
  <div class="header-actions">
    <div class="language-switcher">
      <a href="?lang=en" class="lang-btn <?php echo $lang == 'en' ? 'active' : ''; ?>">EN</a>
      <a href="?lang=ar" class="lang-btn <?php echo $lang == 'ar' ? 'active' : ''; ?>">AR</a>
      <a href="?lang=ku" class="lang-btn <?php echo $lang == 'ku' ? 'active' : ''; ?>">KU</a>
    </div>
    
    <div class="nav-buttons">
      <a class="btn secondary" href="user_dashboard.php"><?php echo t('dashboard'); ?></a>
      <a class="btn secondary" href="user_orders.php"><?php echo t('orders'); ?></a>
      <a class="btn secondary" href="profile.php"><?php echo t('profile'); ?></a>
      <a class="btn secondary" href="logout.php"><?php echo t('logout'); ?></a>
    </div>
  </div>
</div>

<main class="container grid grid-2">
  <section class="card">
    <h1><?php echo t('order_bottle'); ?></h1>
    <p class="muted"><?php echo t('order_description'); ?></p>
    <div class="hr"></div>
    <?php if($message): ?>
      <p class="badge delivered"><?php echo htmlspecialchars($message); ?></p>
    <?php endif; ?>
    
    <!-- Full size image as button -->
    <form method="post" id="order-form">
      <div class="image-container">
        <img src="propane.png" alt="Order Propane" id="propane-image" class="propane-img">
      </div>
    </form>
  </section>
</main>

<!-- Order Confirmation Popup -->
<div class="popup-overlay" id="popup-overlay">
  <div class="popup-content">
    <button class="popup-close" id="close-popup">&times;</button>
    <h2 class="popup-title"><?php echo t('confirm_order'); ?></h2>
    <p class="popup-message"><?php echo t('confirm_order_message'); ?></p>
    <div class="popup-buttons">
      <button class="popup-btn cancel" id="cancel-order"><?php echo t('cancel'); ?></button>
      <button class="popup-btn confirm" id="confirm-order"><?php echo t('confirm'); ?></button>
    </div>
  </div>
</div>

<div class="footer">© <?php echo date('Y'); ?> <?php echo t('propane_service'); ?></div>
</body>
</html>