<?php
session_start();
include 'db.php';
if(!isset($_SESSION['admin'])){ 
    header('Location: admin_login.php'); 
    exit; 
}

// Handle status update
if(isset($_GET['action']) && isset($_GET['id'])){
    $stmt = $pdo->prepare("UPDATE orders SET status=? WHERE id=?");
    $stmt->execute([$_GET['action'], $_GET['id']]);
    header('Location: admin_orders.php');
    exit;
}

// Fetch orders (exclude completed)
$orders = $pdo->query("
    SELECT o.*, u.name as user_name, u.email, u.phone 
    FROM orders o 
    JOIN users u ON o.user_id = u.id 
    WHERE o.status != 'completed'
    ORDER BY o.created_at DESC
")->fetchAll(PDO::FETCH_ASSOC);

// Fetch logo for header
$settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <title>Admin Orders - Dashboard</title>
    <meta http-equiv="refresh" content="30"> <!-- Auto refresh every 30 seconds -->
    <style>
  :root {
    --primary: #1e3a8a;        /* Deep Blue */
    --primary-dark: #1e40af;   /* Darker Blue */
    --secondary: #64748b;      /* Slate Gray */
    --success: #22c55e;        /* Green */
    --danger: #ef4444;         /* Red */
    --warning: #facc15;        /* Yellow */
    --info: #0ea5e9;           /* Sky Blue */
    --light: #f1f5f9;          /* Light Gray */
    --dark: #0f172a;           /* Almost Black */
    --gray: #94a3b8;           /* Neutral Gray */
    --gray-light: #334155;     /* Dark Gray */
    --border-radius: 10px;
    --box-shadow: 0 6px 16px rgba(0,0,0,0.25);
    --transition: all 0.3s ease-in-out;
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: var(--dark);
    color: var(--light);
    line-height: 1.6;
    transition: background 0.3s ease;
}

/* Header */
header {
    background: linear-gradient(90deg, var(--primary), var(--primary-dark));
    color: white;
    padding: 1rem 1.5rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: var(--box-shadow);
    position: sticky;
    top: 0;
    z-index: 100;
    animation: fadeInDown 0.6s ease;
}

header img {
    height: 45px;
    border-radius: 6px;
    transition: transform 0.3s;
}
header img:hover {
    transform: scale(1.05);
}

nav {
    display: flex;
    gap: 1.2rem;
}
nav a {
    color: white;
    text-decoration: none;
    font-weight: 500;
    padding: 0.6rem 1rem;
    border-radius: var(--border-radius);
    transition: var(--transition);
    position: relative;
}
nav a:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
}

/* Container */
.container {
    max-width: 1400px;
    margin: 2rem auto;
    padding: 0 1.5rem;
    animation: fadeIn 0.8s ease;
}

/* Page Title */
.page-title {
    font-size: 2rem;
    color: var(--light);
    font-weight: 700;
    text-shadow: 0 2px 6px rgba(0,0,0,0.4);
}

/* Filter Card */
.filter-card {
    background: #1e293b;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    margin-bottom: 2rem;
    box-shadow: var(--box-shadow);
    transition: var(--transition);
}
.filter-card:hover {
    transform: translateY(-2px);
}
.filter-title {
    font-size: 1.3rem;
    font-weight: 600;
    color: var(--light);
}
input, select {
    padding: 0.8rem;
    border: 1px solid var(--gray-light);
    border-radius: var(--border-radius);
    font-family: inherit;
    font-size: 1rem;
    background: #0f172a;
    color: var(--light);
}
input:focus, select:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.5);
}
/* Action buttons: uniform size & layout */
.action-buttons {
  display: flex;
  gap: 8px;
  flex-wrap: wrap;
  align-items: center;
}

/* Make all .btn inside action-buttons the same size */
.action-buttons .btn {
  min-width: 110px;          /* same width baseline for all buttons */
  height: 40px;              /* uniform height */
  padding: 0 12px;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
  font-size: 0.95rem;
  border-radius: 8px;
  text-decoration: none;
  box-shadow: 0 4px 12px rgba(0,0,0,0.08);
  transition: transform 0.18s ease, box-shadow 0.18s ease, opacity 0.18s ease;
}

/* smaller variant kept but normalized */
.action-buttons .btn-sm {
  min-width: 100px;
  height: 36px;
  font-size: 0.90rem;
  padding: 0 10px;
}

/* icon spacing and size */
.action-buttons .btn i {
  font-size: 14px;
  display: inline-block;
  line-height: 1;
}

/* hover effects */
.action-buttons .btn:hover {
  transform: translateY(-3px);
  box-shadow: 0 8px 22px rgba(0,0,0,0.16);
}

/* ensure Delete (danger) is visually consistent */
.action-buttons .btn-danger { opacity: 0.98; }

/* responsive: stack on very small screens */
@media (max-width:420px) {
  .action-buttons {
    flex-direction: column;
    align-items: stretch;
  }
  .action-buttons .btn { width: 100%; min-width: 0; }
}

/* Summary Card */
.summary-card {
    background: linear-gradient(135deg, var(--primary), var(--primary-dark));
    color: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    margin-bottom: 2rem;
    box-shadow: var(--box-shadow);
    transform: scale(1);
    transition: var(--transition);
}
.summary-card:hover {
    transform: scale(1.02);
}
.summary-amount {
    font-size: 2.2rem;
    font-weight: 800;
}

/* Buttons */
.btn {
    padding: 0.6rem 1.2rem;
    border: none;
    border-radius: var(--border-radius);
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    text-decoration: none;
    font-size: 0.95rem;
}
.btn:hover {
    transform: translateY(-2px);
}
.btn-primary { background: var(--primary); color: white; }
.btn-primary:hover { background: var(--primary-dark); }
.btn-ready { background: var(--success); color: white; }
.btn-ready:hover { background: #16a34a; }
.btn-completed { background: var(--info); color: white; }
.btn-completed:hover { background: #0284c7; }
.btn-danger { background: var(--danger); color: white; }
.btn-danger:hover { background: #dc2626; }

/* Table */
.table-container {
    background: #1e293b;
    border-radius: var(--border-radius);
    overflow: hidden;
    box-shadow: var(--box-shadow);
    margin-bottom: 2rem;
}
table {
    width: 100%;
    border-collapse: collapse;
}
th {
    background: #0f172a;
    padding: 1rem;
    text-align: left;
    font-weight: 600;
    color: var(--light);
}
td {
    padding: 1rem;
    border-bottom: 1px solid #334155;
    color: var(--gray);
}
tr:hover {
    background: rgba(255, 255, 255, 0.05);
}

/* Status */
.status-badge {
    display: inline-block;
    padding: 0.4rem 0.9rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
}
.status-pending { background: #facc15; color: #1f2937; }
.status-ready { background: #22c55e; color: white; }
.status-completed { background: #0ea5e9; color: white; }

/* Empty state */
.empty-state {
    text-align: center;
    padding: 3rem;
    color: var(--gray);
}
.empty-state i {
    font-size: 3rem;
    margin-bottom: 1rem;
    opacity: 0.5;
}

/* Animations */
@keyframes fadeIn {
    from {opacity:0; transform: translateY(10px);}
    to {opacity:1; transform: translateY(0);}
}
@keyframes fadeInDown {
    from {opacity:0; transform: translateY(-20px);}
    to {opacity:1; transform: translateY(0);}
}

/* Responsive */
@media (max-width: 768px) {
    header { flex-direction: column; gap: 1rem; }
    nav { flex-wrap: wrap; justify-content: center; }
    .page-title { font-size: 1.5rem; }
    .filter-form { flex-direction: column; gap: 1rem; }
    table { font-size: 0.9rem; }
    th, td { padding: 0.7rem; }
}


    </style>
</head>
<body>

<header>
    <div class="logo-container">
        <img src="<?= $settings['logo'] ?>" alt="Logo" />
    </div>
    <nav>
        <a href="admin_dashboard.php">Dashboard</a>
        <a href="admin_orders.php">Orders</a>
        <a href="admin_menu.php">Menu Management</a>
        <a href="admin_logout.php">Logout</a>
    </nav>
</header>

<div class="container">
    <div class="page-header">
        <h1 class="page-title">Active Orders</h1>
        <div class="refresh-info">
            <i>↻</i> Auto-refreshes every 30 seconds
        </div>
    </div>

    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User Name</th>
                    <th>Email</th>
                    <th>Phone</th>
                    <th>Total</th>
                    <th>Pickup</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($orders) > 0): ?>
                <?php foreach($orders as $o): 
                    $statusClass = '';
                    if ($o['status'] == 'ready') {
                        $statusClass = 'status-ready';
                    } else {
                        $statusClass = 'status-pending';
                    }
                ?>
                <tr>
                    <td><?= $o['id'] ?></td>
                    <td><?= htmlspecialchars($o['user_name']) ?></td>
                    <td><?= htmlspecialchars($o['email']) ?></td>
                    <td><?= htmlspecialchars($o['phone']) ?></td>
                    <td><?= number_format($o['total_price']) ?> IQD</td>
                    <td><?= $o['pickup_time'] ?></td>
                    <td><span class="status-badge <?= $statusClass ?>"><?= ucfirst($o['status']) ?></span></td>
                    <td>
                        <div class="action-buttons">
                            <a href="admin_orders.php?action=ready&id=<?= $o['id'] ?>" class="btn btn-ready btn-sm">
                                <i></i> Ready
                            </a>
                            <a href="admin_orders.php?action=completed&id=<?= $o['id'] ?>" class="btn btn-completed btn-sm">
                                <i></i> Completed
                            </a>
                        </div>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php else: ?>
                <tr>
                    <td colspan="8">
                        <div class="empty-state">
                            <i>📦</i>
                            <p>No active orders at the moment</p>
                            <small>New orders will appear here automatically</small>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>
</body>
</html>