<?php
session_start();
include 'db.php';
if(!isset($_SESSION['admin'])){ header('Location: admin_login.php'); exit; }

// Handle add menu item
if(isset($_POST['add_item'])){
    $name = $_POST['name'];
    $desc = $_POST['description'];
    $price = $_POST['price'];
    $cat = $_POST['category'];
    $img = '';
    if(isset($_FILES['image']) && $_FILES['image']['tmp_name']){
        $img = 'uploads/'.time().'_'.basename($_FILES['image']['name']);
        move_uploaded_file($_FILES['image']['tmp_name'],$img);
    }
    $stmt = $pdo->prepare("INSERT INTO menu_items(name,description,price,category_id,image) VALUES(?,?,?,?,?)");
    $stmt->execute([$name,$desc,$price,$cat,$img]);
}

// Handle add category
if(isset($_POST['add_category'])){
    $catName = trim($_POST['cat_name']);
    if($catName != ""){
        $stmt = $pdo->prepare("INSERT INTO categories(name) VALUES(?)");
        $stmt->execute([$catName]);
    }
}

// Handle delete item
if(isset($_GET['delete_item'])){
    $id = $_GET['delete_item'];
    $stmt = $pdo->prepare("DELETE FROM menu_items WHERE id=?");
    $stmt->execute([$id]);
    header("Location: admin_menu.php");
    exit;
}

// Handle delete category
if(isset($_GET['delete_category'])){
    $id = $_GET['delete_category'];
    // Check if any items use this category
    $check = $pdo->prepare("SELECT COUNT(*) FROM menu_items WHERE category_id=?");
    $check->execute([$id]);
    $count = $check->fetchColumn();
    
    if($count == 0){
        $stmt = $pdo->prepare("DELETE FROM categories WHERE id=?");
        $stmt->execute([$id]);
    } else {
        $error = "Cannot delete category with menu items. Please reassign items first.";
    }
    header("Location: admin_menu.php");
    exit;
}

// Fetch menu items & categories
$items = $pdo->query("SELECT m.*, c.name as category_name FROM menu_items m LEFT JOIN categories c ON m.category_id=c.id ORDER BY c.name, m.name")->fetchAll(PDO::FETCH_ASSOC);
$cats = $pdo->query("SELECT * FROM categories ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// Fetch logo for header
$settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Menu Management</title>
<style>
    :root {
        --primary: #1e3a8a;       /* deep dark blue */
        --primary-dark: #162c6e;  /* darker navy */
        --secondary: #64748b;     /* slate gray */
        --success: #22c55e;       /* green */
        --danger: #ef4444;        /* red */
        --warning: #facc15;       /* yellow */
        --info: #0ea5e9;          /* light blue */
        --light: #1e293b;         /* dark slate background */
        --dark: #f1f5f9;          /* text color light */
        --gray: #94a3b8;          /* muted gray text */
        --gray-light: #334155;    /* darker border color */
        --border-radius: 10px;
        --box-shadow: 0 4px 16px rgba(0,0,0,0.3);
        --transition: all 0.3s ease;
    }

    * {
        margin: 0;
        padding: 0;
        box-sizing: border-box;
    }

    body {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        background-color: var(--light);
        color: var(--dark);
        line-height: 1.6;
    }

    /* Header */
    header {
        background: linear-gradient(to right, var(--primary), var(--primary-dark));
        color: white;
        padding: 1rem 1.5rem;
        display: flex;
        align-items: center;
        justify-content: space-between;
        box-shadow: var(--box-shadow);
        position: sticky;
        top: 0;
        z-index: 100;
    }

    .logo-container {
        display: flex;
        align-items: center;
    }

    header img {
        height: 45px;
        border-radius: 6px;
    }

    nav {
        display: flex;
        gap: 1.5rem;
        flex-wrap: wrap;
    }

    nav a {
        color: white;
        text-decoration: none;
        font-weight: 500;
        padding: 0.5rem 1rem;
        border-radius: var(--border-radius);
        transition: var(--transition);
        position: relative;
    }

    nav a:hover {
        background-color: rgba(255,255,255,0.15);
    }

    nav a::after {
        content: '';
        position: absolute;
        bottom: -5px;
        left: 0;
        width: 0;
        height: 3px;
        background-color: white;
        transition: var(--transition);
        border-radius: 10px;
    }

    nav a:hover::after {
        width: 100%;
    }

    /* Container */
    .container {
        max-width: 1200px;
        margin: 2rem auto;
        padding: 0 1.5rem;
    }

    /* Cards */
    .card {
        background-color: #1e293b;
        border-radius: var(--border-radius);
        padding: 1.5rem;
        margin-bottom: 2rem;
        box-shadow: var(--box-shadow);
        color: var(--dark);
    }

    .card-header {
        margin-bottom: 1rem;
        padding-bottom: 0.8rem;
        border-bottom: 1px solid var(--gray-light);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-title {
        font-size: 1.3rem;
        font-weight: 600;
    }

    /* Forms */
    .form-group {
        margin-bottom: 1rem;
    }

    label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 500;
        color: var(--gray);
    }

    input, select, textarea {
        width: 100%;
        padding: 0.8rem;
        border: 1px solid var(--gray-light);
        border-radius: var(--border-radius);
        background-color: #0f172a;
        color: var(--dark);
        font-size: 1rem;
    }

    input:focus, select:focus, textarea:focus {
        outline: none;
        border-color: var(--primary);
        box-shadow: 0 0 0 3px rgba(30,58,138,0.4);
    }

    /* Buttons */
    .btn {
        padding: 0.7rem 1.5rem;
        border: none;
        border-radius: var(--border-radius);
        font-weight: 500;
        cursor: pointer;
        transition: var(--transition);
        display: inline-flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        text-decoration: none;
        font-size: 1rem;
    }

    .btn-primary {
        background-color: var(--primary);
        color: white;
    }

    .btn-primary:hover {
        background-color: var(--primary-dark);
        transform: translateY(-2px);
    }

    .btn-danger {
        background-color: var(--danger);
        color: white;
    }

    .btn-danger:hover {
        background-color: #b91c1c;
        transform: translateY(-2px);
    }

    .btn-sm {
        padding: 0.4rem 0.8rem;
        font-size: 0.85rem;
    }

    /* Tables */
    .table-container {
        background-color: #1e293b;
        border-radius: var(--border-radius);
        overflow-x: auto;
        box-shadow: var(--box-shadow);
        margin-bottom: 2rem;
    }

    table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
    }

    th {
        background-color: #0f172a;
        padding: 1rem;
        text-align: left;
        font-weight: 600;
        color: var(--dark);
        border-bottom: 2px solid var(--gray-light);
    }

    td {
        padding: 1rem;
        border-bottom: 1px solid var(--gray-light);
        vertical-align: middle;
        color: var(--gray);
    }

    tr:hover {
        background-color: #334155;
    }

    .item-image {
        width: 60px;
        height: 60px;
        object-fit: cover;
        border-radius: var(--border-radius);
    }

    /* Alerts */
    .alert {
        padding: 1rem;
        border-radius: var(--border-radius);
        margin-bottom: 1.5rem;
    }

    .alert-danger {
        background-color: #7f1d1d;
        color: #fecaca;
        border: 1px solid #b91c1c;
    }

    /* Responsive */
    @media (max-width: 992px) {
        .col-6 {
            flex: 0 0 100%;
            max-width: 100%;
        }
    }

    @media (max-width: 768px) {
        header {
            flex-direction: column;
            gap: 1rem;
            padding: 1rem;
        }

        nav {
            justify-content: center;
        }

        .page-header {
            flex-direction: column;
            align-items: flex-start;
            gap: 1rem;
        }

        table {
            min-width: 600px;
        }
    }
</style>

</head>
<body>
<header>
    <div class="logo-container">
        <img src="<?= $settings['logo'] ?>" alt="Logo" />
    </div>
    <nav>
        <a href="admin_dashboard.php">Dashboard</a>
        <a href="admin_orders.php">Orders</a>
        <a href="admin_menu.php">Menu Management</a>
        <a href="admin_logout.php">Logout</a>
    </nav>
</header>

<div class="container">
    <div class="page-header">
        <h1 class="page-title">Menu Management</h1>
    </div>
    
    <?php if(isset($error)): ?>
    <div class="alert alert-danger">
        <span>⚠️</span>
        <div><?= $error ?></div>
    </div>
    <?php endif; ?>
    
    <div class="row">
        <div class="col-6">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Add Menu Item</h2>
                </div>
                <form method="POST" enctype="multipart/form-data">
                    <div class="form-group">
                        <label for="name">Item Name</label>
                        <input type="text" id="name" name="name" placeholder="Enter item name" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="description">Description</label>
                        <input type="text" id="description" name="description" placeholder="Enter description" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="price">Price</label>
                        <input type="number" id="price" name="price" step="0.01" placeholder="Enter price" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="category">Category</label>
                        <select id="category" name="category" required>
                            <option value="">Select a category</option>
                            <?php foreach($cats as $c): ?>
                            <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="image">Item Image</label>
                        <input type="file" id="image" name="image" accept="image/*">
                    </div>
                    
                    <button type="submit" name="add_item" class="btn btn-primary">
                        <span>+</span> Add Item
                    </button>
                </form>
            </div>
        </div>
        
        <div class="col-6">
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Add New Category</h2>
                </div>
                <form method="POST">
                    <div class="form-group">
                        <label for="cat_name">Category Name</label>
                        <input type="text" id="cat_name" name="cat_name" placeholder="Enter category name" required>
                    </div>
                    
                    <button type="submit" name="add_category" class="btn btn-primary">
                        <span>+</span> Add Category
                    </button>
                </form>
            </div>
            
            <div class="card">
                <div class="card-header">
                    <h2 class="card-title">Existing Categories</h2>
                </div>
                <div class="category-list">
                    <?php if(count($cats) > 0): ?>
                    <?php foreach($cats as $c): ?>
                    <div class="category-badge">
                        <span><?= htmlspecialchars($c['name']) ?></span>
                        <a href="admin_menu.php?delete_category=<?= $c['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this category?')">
                            <span>×</span>
                        </a>
                    </div>
                    <?php endforeach; ?>
                    <?php else: ?>
                    <p>No categories found. Add a category to get started.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <div class="card">
        <div class="card-header">
            <h2 class="card-title">Menu Items</h2>
        </div>
        
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Category</th>
                        <th>Price</th>
                        <th>Image</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if(count($items) > 0): ?>
                    <?php foreach($items as $i): ?>
                    <tr>
                        <td><?= htmlspecialchars($i['name']) ?></td>
                        <td><?= htmlspecialchars($i['category_name']) ?></td>
<td><?= number_format((float)$i['price'], 0) ?> IQD</td>
                        <td>
                            <?php if($i['image']): ?>
                            <img src="<?= htmlspecialchars($i['image']) ?>" alt="<?= htmlspecialchars($i['name']) ?>" class="item-image">
                            <?php else: ?>
                            <span>No image</span>
                            <?php endif; ?>
                        </td>
                        <td>
                            <a href="admin_menu.php?delete_item=<?= $i['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this item?')">
                                <span>×</span> Delete
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                    <?php else: ?>
                    <tr>
                        <td colspan="5" style="text-align: center; padding: 2rem;">
                            No menu items found. Add items to get started.
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    // Simple form validation
    document.addEventListener('DOMContentLoaded', function() {
        const forms = document.querySelectorAll('form');
        forms.forEach(form => {
            form.addEventListener('submit', function(e) {
                let valid = true;
                const inputs = form.querySelectorAll('input[required], select[required]');
                
                inputs.forEach(input => {
                    if (!input.value.trim()) {
                        valid = false;
                        input.style.borderColor = 'var(--danger)';
                    } else {
                        input.style.borderColor = '';
                    }
                });
                
                if (!valid) {
                    e.preventDefault();
                    alert('Please fill in all required fields.');
                }
            });
        });
    });
</script>
</body>
</html>