<?php
session_start();
include 'db.php';
if(!isset($_SESSION['admin'])){ header('Location: admin_login.php'); exit; }
// Handle deletion
if(isset($_GET['delete_id'])){
    $stmt = $pdo->prepare("DELETE FROM orders WHERE id=?");
    $stmt->execute([$_GET['delete_id']]);
    header("Location: admin_orders.php?date=" . $selected_date);
    exit;
}

// Get selected date or default to today
$selected_date = isset($_GET['date']) ? $_GET['date'] : date("Y-m-d");

// Fetch orders for selected date
$stmt = $pdo->prepare("
    SELECT o.*, u.name as user_name 
    FROM orders o 
    JOIN users u ON u.id=o.user_id 
    WHERE DATE(o.created_at) = ?
    ORDER BY o.created_at DESC
");
$stmt->execute([$selected_date]);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Calculate total
$total_stmt = $pdo->prepare("SELECT SUM(total_price) as total FROM orders WHERE DATE(created_at) = ?");
$total_stmt->execute([$selected_date]);
$total_today = $total_stmt->fetch(PDO::FETCH_ASSOC)['total'] ?? 0;

// Handle status update
if(isset($_GET['action']) && isset($_GET['id'])){
    $stmt = $pdo->prepare("UPDATE orders SET status=? WHERE id=?");
    $stmt->execute([$_GET['action'], $_GET['id']]);
    header("Location: admin_orders.php?date=" . $selected_date);
    exit;
}
// Fetch orders
$stmt = $pdo->prepare("SELECT * FROM orders WHERE DATE(created_at)=? ORDER BY id DESC");
$stmt->execute([$selected_date]);
$orders = $stmt->fetchAll(PDO::FETCH_ASSOC);

// For each order, fetch items
foreach($orders as &$order){
    $stmt_items = $pdo->prepare("SELECT * FROM order_items WHERE order_id=?");
    $stmt_items->execute([$order['id']]);
    $order['items'] = $stmt_items->fetchAll(PDO::FETCH_ASSOC);
}

// Calculate total for the day
$total_today = array_sum(array_column($orders, 'total_price'));
// Fetch logo for header
$settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Orders Management</title>
    <style>
:root {
    --primary: #1e3a8a;        /* Deep Blue */
    --primary-dark: #1e40af;   /* Darker Blue */
    --secondary: #64748b;      /* Slate Gray */
    --success: #22c55e;        /* Green */
    --danger: #ef4444;         /* Red */
    --warning: #facc15;        /* Yellow */
    --info: #0ea5e9;           /* Sky Blue */
    --light: #f1f5f9;          /* Light Gray */
    --dark: #0f172a;           /* Almost Black */
    --gray: #94a3b8;           /* Neutral Gray */
    --gray-light: #334155;     /* Dark Gray */
    --border-radius: 10px;
    --box-shadow: 0 6px 16px rgba(0,0,0,0.25);
    --transition: all 0.3s ease-in-out;
}

* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    background: var(--dark);
    color: var(--light);
    line-height: 1.6;
    transition: background 0.3s ease;
}

/* Header */
header {
    background: linear-gradient(90deg, var(--primary), var(--primary-dark));
    color: white;
    padding: 1rem 1.5rem;
    display: flex;
    align-items: center;
    justify-content: space-between;
    box-shadow: var(--box-shadow);
    position: sticky;
    top: 0;
    z-index: 100;
    animation: fadeInDown 0.6s ease;
}

header img {
    height: 45px;
    border-radius: 6px;
    transition: transform 0.3s;
}
header img:hover {
    transform: scale(1.05);
}

nav {
    display: flex;
    gap: 1.2rem;
}
nav a {
    color: white;
    text-decoration: none;
    font-weight: 500;
    padding: 0.6rem 1rem;
    border-radius: var(--border-radius);
    transition: var(--transition);
    position: relative;
}
nav a:hover {
    background: rgba(255, 255, 255, 0.2);
    transform: translateY(-2px);
}

/* Container */
.container {
    max-width: 1400px;
    margin: 2rem auto;
    padding: 0 1.5rem;
    animation: fadeIn 0.8s ease;
}

/* Page Title */
.page-title {
    font-size: 2rem;
    color: var(--light);
    font-weight: 700;
    text-shadow: 0 2px 6px rgba(0,0,0,0.4);
}

/* Filter Card */
.filter-card {
    background: #1e293b;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    margin-bottom: 2rem;
    box-shadow: var(--box-shadow);
    transition: var(--transition);
}
.filter-card:hover {
    transform: translateY(-2px);
}
.filter-title {
    font-size: 1.3rem;
    font-weight: 600;
    color: var(--light);
}
input, select {
    padding: 0.8rem;
    border: 1px solid var(--gray-light);
    border-radius: var(--border-radius);
    font-family: inherit;
    font-size: 1rem;
    background: #0f172a;
    color: var(--light);
}
input:focus, select:focus {
    outline: none;
    border-color: var(--primary);
    box-shadow: 0 0 0 3px rgba(30, 64, 175, 0.5);
}
/* Action buttons: uniform size & layout */
.action-buttons {
  display: flex;
  gap: 8px;
  flex-wrap: wrap;
  align-items: center;
}

/* Make all .btn inside action-buttons the same size */
.action-buttons .btn {
  min-width: 110px;          /* same width baseline for all buttons */
  height: 40px;              /* uniform height */
  padding: 0 12px;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  gap: 8px;
  font-size: 0.95rem;
  border-radius: 8px;
  text-decoration: none;
  box-shadow: 0 4px 12px rgba(0,0,0,0.08);
  transition: transform 0.18s ease, box-shadow 0.18s ease, opacity 0.18s ease;
}

/* smaller variant kept but normalized */
.action-buttons .btn-sm {
  min-width: 100px;
  height: 36px;
  font-size: 0.90rem;
  padding: 0 10px;
}

/* icon spacing and size */
.action-buttons .btn i {
  font-size: 14px;
  display: inline-block;
  line-height: 1;
}

/* hover effects */
.action-buttons .btn:hover {
  transform: translateY(-3px);
  box-shadow: 0 8px 22px rgba(0,0,0,0.16);
}

/* ensure Delete (danger) is visually consistent */
.action-buttons .btn-danger { opacity: 0.98; }

/* responsive: stack on very small screens */
@media (max-width:420px) {
  .action-buttons {
    flex-direction: column;
    align-items: stretch;
  }
  .action-buttons .btn { width: 100%; min-width: 0; }
}

/* Summary Card */
.summary-card {
    background: linear-gradient(135deg, var(--primary), var(--primary-dark));
    color: white;
    border-radius: var(--border-radius);
    padding: 1.5rem;
    margin-bottom: 2rem;
    box-shadow: var(--box-shadow);
    transform: scale(1);
    transition: var(--transition);
}
.summary-card:hover {
    transform: scale(1.02);
}
.summary-amount {
    font-size: 2.2rem;
    font-weight: 800;
}

/* Buttons */
.btn {
    padding: 0.6rem 1.2rem;
    border: none;
    border-radius: var(--border-radius);
    font-weight: 500;
    cursor: pointer;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    text-decoration: none;
    font-size: 0.95rem;
}
.btn:hover {
    transform: translateY(-2px);
}
.btn-primary { background: var(--primary); color: white; }
.btn-primary:hover { background: var(--primary-dark); }
.btn-ready { background: var(--success); color: white; }
.btn-ready:hover { background: #16a34a; }
.btn-completed { background: var(--info); color: white; }
.btn-completed:hover { background: #0284c7; }
.btn-danger { background: var(--danger); color: white; }
.btn-danger:hover { background: #dc2626; }

/* Table */
.table-container {
    background: #1e293b;
    border-radius: var(--border-radius);
    overflow: hidden;
    box-shadow: var(--box-shadow);
    margin-bottom: 2rem;
}
table {
    width: 100%;
    border-collapse: collapse;
}
th {
    background: #0f172a;
    padding: 1rem;
    text-align: left;
    font-weight: 600;
    color: var(--light);
}
td {
    padding: 1rem;
    border-bottom: 1px solid #334155;
    color: var(--gray);
}
tr:hover {
    background: rgba(255, 255, 255, 0.05);
}

/* Status */
.status-badge {
    display: inline-block;
    padding: 0.4rem 0.9rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 600;
}
.status-pending { background: #facc15; color: #1f2937; }
.status-ready { background: #22c55e; color: white; }
.status-completed { background: #0ea5e9; color: white; }

/* Empty state */
.empty-state {
    text-align: center;
    padding: 3rem;
    color: var(--gray);
}
.empty-state i {
    font-size: 3rem;
    margin-bottom: 1rem;
    opacity: 0.5;
}

/* Animations */
@keyframes fadeIn {
    from {opacity:0; transform: translateY(10px);}
    to {opacity:1; transform: translateY(0);}
}
@keyframes fadeInDown {
    from {opacity:0; transform: translateY(-20px);}
    to {opacity:1; transform: translateY(0);}
}

/* Responsive */
@media (max-width: 768px) {
    header { flex-direction: column; gap: 1rem; }
    nav { flex-wrap: wrap; justify-content: center; }
    .page-title { font-size: 1.5rem; }
    .filter-form { flex-direction: column; gap: 1rem; }
    table { font-size: 0.9rem; }
    th, td { padding: 0.7rem; }
}


    </style>
</head>
<body>
<header>
    <div class="logo-container">
        <img src="<?= $settings['logo'] ?>" alt="Logo" />
    </div>
    <nav>
        <a href="admin_dashboard.php">Dashboard</a>
        <a href="admin_orders.php">Orders</a>
        <a href="admin_menu.php">Menu Management</a>
        <a href="admin_logout.php">Logout</a>
    </nav>
</header>

<div class="container">
    <div class="page-header">
        <h1 class="page-title">Orders Management</h1>
    </div>
    
    <!-- Filter Card -->
    <div class="filter-card">
        <div class="filter-header">
            <h2 class="filter-title">Filter Orders</h2>
        </div>
        <form method="get" class="filter-form">
            <div class="form-group">
                <label for="date">Select Date</label>
                <input type="date" id="date" name="date" value="<?= htmlspecialchars($selected_date) ?>" required>
            </div>
            <button type="submit" class="btn btn-primary">View Orders</button>
        </form>
    </div>
    
    <!-- Summary Card -->
    <div class="summary-card">
        <div class="summary-title">Total for <?= htmlspecialchars($selected_date) ?></div>
        <div class="summary-amount"><?= number_format($total_today) ?> IQD</div>
    </div>
    
    <!-- Orders Table -->
    <div class="table-container">
        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Total (IQD)</th>
                    <th>Pickup Time</th>
                    <th>order info</th>
                    <th>Order Type</th>
                    <th>Status</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if(count($orders) > 0): ?>
                <?php foreach($orders as $o): 
                    $statusClass = 'status-' . $o['status'];
                ?>
                <tr>
                    <td><?= $o['id'] ?></td>
                    <td><?= htmlspecialchars($o['user_name']) ?></td>
                    <td><?= number_format($o['total_price']) ?></td>
                    <td><?= htmlspecialchars($o['pickup_time']) ?></td>
<td>
    <ul>
        <?php foreach($o['items'] as $item): ?>
            <li><?= htmlspecialchars($item['item_name']) ?> x<?= $item['quantity'] ?></li>
        <?php endforeach; ?>
    </ul>
</td>
                    <td>
    <?= $o['order_type'] == 'pickup' ? 'Pickup' : 'Dine-in (Table ' . htmlspecialchars($o['table_number']) . ')' ?>
</td>
<td>
  <span class="status-badge <?= $statusClass ?>"><?= ucfirst($o['status']) ?></span>
</td>
<td>
  <div class="action-buttons">
    <a href="admin_orders.php?action=ready&id=<?= $o['id'] ?>&date=<?= $selected_date ?>"
       class="btn btn-ready btn-sm" title="Mark Ready">
      <i class="fas fa-check-circle"></i> Ready
    </a>

    <a href="admin_orders.php?action=completed&id=<?= $o['id'] ?>&date=<?= $selected_date ?>"
       class="btn btn-completed btn-sm" title="Mark Completed">
      <i class="fas fa-check"></i> Completed
    </a>

    <a href="admin_orders.php?delete_id=<?= $o['id'] ?>&date=<?= $selected_date ?>"
       class="btn btn-danger btn-sm"
       onclick="return confirm('Are you sure you want to delete this order?');" title="Delete Order">
      <i class="fas fa-trash-alt"></i> Delete
    </a>

    <a href="print_invoice.php?order_id=<?= $o['id'] ?>" target="_blank" class="btn btn-primary btn-sm" title="Print Invoice">
      <i class="fas fa-print"></i> Print
    </a>
  </div>
</td>

                </tr>
                <?php endforeach; ?>
                <?php else: ?>
                <tr>
                    <td colspan="6">
                        <div class="empty-state">
                            <i>ðŸ“¦</i>
                            <p>No orders found for this date</p>
                            <small>Try selecting a different date</small>
                        </div>
                    </td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
    // Add today button functionality
    document.addEventListener('DOMContentLoaded', function() {
        // Set max date to today
        const dateInput = document.getElementById('date');
        const today = new Date().toISOString().split('T')[0];
        dateInput.setAttribute('max', today);
        
        // Add a "Today" button
        const todayButton = document.createElement('button');
        todayButton.type = 'button';
        todayButton.textContent = 'Today';
        todayButton.classList.add('btn', 'btn-primary');
        todayButton.style.marginLeft = '10px';
        todayButton.addEventListener('click', function() {
            dateInput.value = today;
            dateInput.form.submit();
        });
        
        dateInput.parentNode.appendChild(todayButton);
    });
</script>
</body>
</html>