<?php
session_start();
include 'db.php';

if(!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

if($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['qty'])) {

    $order_type = $_POST['order_type'] ?? 'pickup';
    $table_number = ($order_type === 'dinein') ? intval($_POST['table_number']) : null;
    $pickup_minutes = intval($_POST['pickup_minutes'] ?? 10);

    $order_qty = array_filter($_POST['qty'], fn($q) => intval($q) > 0);
    if(empty($order_qty)) die("Please select at least one item.");

    $items_ordered = [];
    $total = 0;

    foreach($order_qty as $id => $qty) {
        $stmt = $pdo->prepare("SELECT id, name, price FROM menu_items WHERE id=?");
        $stmt->execute([$id]);
        $item = $stmt->fetch(PDO::FETCH_ASSOC);
        if($item){
            $items_ordered[] = [
                'id' => $id,
                'name' => $item['name'],
                'price' => $item['price'],
                'qty' => intval($qty)
            ];
            $total += $item['price'] * $qty;
        }
    }

    // Save everything in session for payment page
    $_SESSION['checkout'] = [
        'user_id' => $user_id,
        'items' => $items_ordered,
        'total' => $total,
        'order_type' => $order_type,
        'table_number' => $table_number,
        'pickup_minutes' => $pickup_minutes
    ];

    header('Location: payment_method.php');
    exit;
} else {
    header('Location: menu.php');
    exit;
}
