<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pickup Platform</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary-green: #deec5dff;
            --primary-blue: #4b94beff;
            --light-blue: #56b3c4ff;
            --background: linear-gradient(135deg, #fef9f4 0%, #fdf1d6 100%);
            --card-bg: rgba(255, 255, 255, 0.9);
            --text-dark: #333;
            --text-light: #666;
            --shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
            --shadow-hover: 0 12px 40px rgba(0, 0, 0, 0.15);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: var(--background);
            margin: 0;
            color: var(--text-dark);
            line-height: 1.6;
            overflow-x: hidden;
        }

        /* Header & Navigation */
        header {
            background: linear-gradient(90deg, var(--primary-green), var(--primary-blue));
            color: #fff;
            padding: 15px 5%;
            text-align: center;
            box-shadow: var(--shadow);
            position: sticky;
            top: 0;
            z-index: 1000;
            backdrop-filter: blur(10px);
        }

        .header-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        header h1 {
            margin: 0;
            font-size: 1.8em;
            font-weight: 700;
            letter-spacing: -0.5px;
        }

        nav {
            display: flex;
            align-items: center;
        }

        nav a {
            color: #fff;
            margin: 0 15px;
            text-decoration: none;
            font-weight: 500;
            position: relative;
            transition: all 0.3s ease;
        }

        nav a:after {
            content: '';
            position: absolute;
            width: 0;
            height: 2px;
            bottom: -5px;
            left: 50%;
            background-color: #fff;
            transition: all 0.3s ease;
            transform: translateX(-50%);
        }

        nav a:hover:after {
            width: 100%;
        }

        .menu-toggle {
            display: none;
            background: none;
            border: none;
            color: white;
            font-size: 1.5rem;
            cursor: pointer;
        }

        /* Hero Section */
        .hero {
            text-align: center;
            padding: 100px 20px;
            position: relative;
            overflow: hidden;
        }

        .hero::before {
            content: '';
            position: absolute;
            top: -50%;
            left: -50%;
            width: 200%;
            height: 200%;
            background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, rgba(255,255,255,0) 60%);
            transform: rotate(30deg);
            z-index: 0;
        }

        .hero-content {
            position: relative;
            z-index: 1;
            max-width: 800px;
            margin: 0 auto;
            animation: fadeInUp 1s ease-out;
        }

        .hero h2 {
            font-size: 2.8em;
            color: var(--primary-blue);
            margin-bottom: 15px;
            font-weight: 800;
            letter-spacing: -0.5px;
        }

        .hero p {
            font-size: 1.2em;
            color: var(--primary-green);
            margin-bottom: 40px;
            max-width: 600px;
            margin-left: auto;
            margin-right: auto;
        }

        .buttons {
            display: flex;
            justify-content: center;
            gap: 20px;
            flex-wrap: wrap;
        }

        .btn {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            padding: 15px 35px;
            background: linear-gradient(90deg, var(--primary-green), var(--primary-blue));
            color: #fff;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            transition: all 0.3s ease;
            box-shadow: var(--shadow);
            position: relative;
            overflow: hidden;
        }

        .btn:before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: 0.5s;
        }

        .btn:hover:before {
            left: 100%;
        }

        .btn:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-hover);
        }

        .btn i {
            margin-right: 10px;
        }

        /* Sections */
        section {
            padding: 80px 20px;
            max-width: 1200px;
            margin: auto;
        }

        .section-header {
            text-align: center;
            margin-bottom: 60px;
        }

        .section-header h3 {
            color: var(--primary-blue);
            margin-bottom: 20px;
            font-size: 2.2em;
            font-weight: 700;
            position: relative;
            display: inline-block;
        }

        .section-header h3:after {
            content: '';
            position: absolute;
            width: 60px;
            height: 4px;
            background: linear-gradient(90deg, var(--primary-green), var(--primary-blue));
            bottom: -15px;
            left: 50%;
            transform: translateX(-50%);
            border-radius: 2px;
        }

        .section-content {
            font-size: 1.1em;
            color: var(--text-dark);
            max-width: 800px;
            margin: 0 auto;
            text-align: center;
        }

        /* Features Grid */
        .features {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
            gap: 30px;
            margin-top: 50px;
        }

        .feature-card {
            background: var(--card-bg);
            border-radius: 16px;
            padding: 30px;
            box-shadow: var(--shadow);
            transition: all 0.3s ease;
            text-align: center;
        }

        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: var(--shadow-hover);
        }

        .feature-icon {
            width: 70px;
            height: 70px;
            background: linear-gradient(135deg, var(--primary-green), var(--primary-blue));
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 20px;
            color: white;
            font-size: 1.8rem;
        }

        .feature-card h4 {
            color: var(--primary-blue);
            margin-bottom: 15px;
            font-size: 1.4em;
        }

        .feature-card p {
            color: var(--text-light);
        }

        /* Footer */
        footer {
            background: linear-gradient(90deg, var(--primary-green), var(--primary-blue));
            text-align: center;
            padding: 30px 20px;
            margin-top: 80px;
            color: white;
        }

        .footer-content {
            max-width: 1200px;
            margin: 0 auto;
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .animate-on-scroll {
            opacity: 0;
            transform: translateY(30px);
            transition: all 0.8s ease;
        }

        .is-visible {
            opacity: 1;
            transform: translateY(0);
        }

        /* Responsive Design */
        @media (max-width: 900px) {
            .header-container {
                flex-direction: column;
                gap: 15px;
            }
            
            nav {
                margin-top: 15px;
            }
        }

        @media (max-width: 768px) {
            .hero h2 {
                font-size: 2.2em;
            }
            
            .hero p {
                font-size: 1.1em;
            }
            
            .btn {
                padding: 12px 25px;
            }
            
            .menu-toggle {
                display: block;
                position: absolute;
                top: 20px;
                right: 20px;
            }
            
            nav {
                display: none;
                flex-direction: column;
                width: 100%;
                margin-top: 20px;
            }
            
            nav.active {
                display: flex;
            }
            
            nav a {
                margin: 10px 0;
            }
            
            .features {
                grid-template-columns: 1fr;
            }
        }

        @media (max-width: 480px) {
            .hero h2 {
                font-size: 1.8em;
            }
            
            .buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
            }
            
            .section-header h3 {
                font-size: 1.8em;
            }
        }
    </style>
</head>
<body>

<header>
    <div class="header-container">
        <h1>Pickup Platform</h1>
        <button class="menu-toggle" id="menuToggle">
            <i class="fas fa-bars"></i>
        </button>
        <nav id="mainNav">
            
            <a href="./home.php">home</a>
                        <a href="menu.php">Menu</a>
            <a href="my_orders.php">Myorders</a>
            <a href="#about">About</a>
            <a href="#services">Services</a>
            <a href="#features">Features</a>
            <a href="./logout.php">logout</a>

        </nav>
    </div>
</header>

<div class="hero">
    <div class="hero-content">
        <h2>Fast, Simple & Reliable Pickups </h2>
        <p>Your orders, ready when you are. Stay connected and skip the wait.</p>
        <div class="buttons">
            <a href="#" class="btn"><i class="fas fa-sign-in-alt"></i> Ipohone</a>
            <a href="#" class="btn"><i class="fas fa-user-plus"></i> Android</a>
        </div>
    </div>
</div>

<section id="about">
    <div class="section-header animate-on-scroll">
        <h3>About Us</h3>
    </div>
    <div class="section-content animate-on-scroll">
        <p>
            Our platform is designed to make order pickups easier than ever. 
            We focus on speed, convenience, and reliability — so you can spend less time waiting 
            and more time doing what you love.
        </p>
    </div>
</section>

<section id="services">
    <div class="section-header animate-on-scroll">
        <h3>Our Services</h3>
    </div>
    <div class="section-content animate-on-scroll">
        <p>
            From seamless account management to real-time updates, 
            our platform helps you stay organized and in control of your pickups. 
            Simple. Modern. Always available.
        </p>
    </div>
</section>

<section id="features">
    <div class="section-header animate-on-scroll">
        <h3>Key Features</h3>
    </div>
    <div class="features">
        <div class="feature-card animate-on-scroll">
            <div class="feature-icon">
                <i class="fas fa-bolt"></i>
            </div>
            <h4>Instant Notifications</h4>
            <p>Get real-time alerts when your order is ready for pickup</p>
        </div>
        <div class="feature-card animate-on-scroll">
            <div class="feature-icon">
                <i class="fas fa-map-marker-alt"></i>
            </div>
            <h4>Live Tracking</h4>
            <p>Track your order status and estimated pickup time</p>
        </div>
        <div class="feature-card animate-on-scroll">
            <div class="feature-icon">
                <i class="fas fa-clock"></i>
            </div>
            <h4>Time Saving</h4>
            <p>No more waiting in lines with our efficient system</p>
        </div>
    </div>
</section>

<footer>
    <div class="footer-content">
        &copy; <?php echo date("Y"); ?> Pickup Platform. All rights reserved.
    </div>
</footer>

<script>
    // Mobile menu toggle
    document.getElementById('menuToggle').addEventListener('click', function() {
        document.getElementById('mainNav').classList.toggle('active');
    });

    // Scroll animations
    document.addEventListener('DOMContentLoaded', function() {
        const animatedElements = document.querySelectorAll('.animate-on-scroll');
        
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    entry.target.classList.add('is-visible');
                }
            });
        }, {
            threshold: 0.1
        });
        
        animatedElements.forEach(element => {
            observer.observe(element);
        });
        
        // Smooth scrolling for anchor links
        document.querySelectorAll('a[href^="#"]').forEach(anchor => {
            anchor.addEventListener('click', function(e) {
                if (this.getAttribute('href') !== '#') {
                    e.preventDefault();
                    
                    const targetId = this.getAttribute('href');
                    const targetElement = document.querySelector(targetId);
                    
                    if (targetElement) {
                        window.scrollTo({
                            top: targetElement.offsetTop - 100,
                            behavior: 'smooth'
                        });
                        
                        // Close mobile menu if open
                        document.getElementById('mainNav').classList.remove('active');
                    }
                }
            });
        });
    });
</script>

</body>
</html>