<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
include 'db.php';

if(isset($_POST['login'])){
    $email = $_POST['email'];
    $password = $_POST['password'];

    $stmt = $pdo->prepare("SELECT * FROM users WHERE email=?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if($user && password_verify($password, $user['password'])){
        $_SESSION['user_id'] = $user['id'];
        header('Location: menu.php');
        exit;
    } else {
        $error = "Invalid email or password";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<title>Login</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
        body {
            font-family: 'Inter', 'Segoe UI', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #fdfbf7 0%, #f8f4e6 50%, #f5f0e1 100%);
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            color: #56b3c4ff;
            position: relative;
            overflow-x: hidden;
        }
        
        body::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: radial-gradient(circle at 20% 80%, rgba(222, 236, 93, 0.1) 0%, transparent 50%),
                        radial-gradient(circle at 80% 20%, rgba(75, 148, 190, 0.1) 0%, transparent 50%);
            pointer-events: none;
        }
        
        .container {
            max-width: 420px;
            width: 90%;
            padding: 40px 35px;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(20px);
            border-radius: 24px;
            border: 1px solid rgba(255, 255, 255, 0.2);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.08), 
                        0 8px 16px rgba(0, 0, 0, 0.04),
                        inset 0 1px 0 rgba(255, 255, 255, 0.6);
            text-align: center;
            animation: fadeIn 0.8s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            z-index: 1;
        }
        
        .container::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: linear-gradient(135deg, rgba(255, 255, 255, 0.1) 0%, rgba(255, 255, 255, 0.05) 100%);
            border-radius: 24px;
            pointer-events: none;
        }
        
        .container h2 {
            margin-bottom: 12px;
            font-size: 2.2em;
            font-weight: 700;
            color: #4b94beff;
            letter-spacing: -0.02em;
            line-height: 1.2;
            position: relative;
            z-index: 2;
        }
        
        .tagline {
            font-size: 1.05em;
            color: #deec5dff;
            margin-bottom: 32px;
            font-weight: 500;
            letter-spacing: 0.01em;
            opacity: 0.9;
            position: relative;
            z-index: 2;
        }
        
        input {
            width: 100%;
            padding: 16px 20px;
            margin: 12px 0;
            border: 2px solid rgba(221, 221, 221, 0.3);
            border-radius: 16px;
            font-size: 1em;
            font-weight: 500;
            outline: none;
            background: rgba(255, 255, 255, 0.8);
            backdrop-filter: blur(10px);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-sizing: border-box;
            position: relative;
            z-index: 2;
        }
        
        input:focus {
            border-color: #4b94beff;
            background: rgba(255, 255, 255, 0.95);
            box-shadow: 0 0 0 4px rgba(75, 148, 190, 0.1),
                        0 8px 16px rgba(75, 148, 190, 0.08);
            transform: translateY(-2px);
        }
        
        input::placeholder {
            color: rgba(86, 179, 196, 0.6);
            font-weight: 400;
        }
        
        button {
            width: 100%;
            padding: 16px 20px;
            background: linear-gradient(135deg, #deec5dff 0%, #4b94beff 100%);
            color: #fff;
            border: none;
            border-radius: 16px;
            cursor: pointer;
            font-size: 1.1em;
            font-weight: 600;
            letter-spacing: 0.02em;
            margin-top: 8px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            box-shadow: 0 8px 16px rgba(75, 148, 190, 0.2);
            position: relative;
            overflow: hidden;
            z-index: 2;
        }
        
        button::before {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: left 0.5s ease;
        }
        
        button:hover {
            transform: translateY(-3px);
            box-shadow: 0 12px 24px rgba(75, 148, 190, 0.25);
        }
        
        button:hover::before {
            left: 100%;
        }
        
        button:active {
            transform: translateY(-1px);
        }
        
        .error {
            color: #e74c3c;
            margin-bottom: 16px;
            font-size: 0.95em;
            font-weight: 500;
            padding: 12px 16px;
            background: rgba(231, 76, 60, 0.08);
            border-radius: 12px;
            border-left: 4px solid #e74c3c;
            position: relative;
            z-index: 2;
            display: none;
        }
        
        p {
            margin-top: 24px;
            font-size: 0.95em;
            font-weight: 500;
            color: rgba(86, 179, 196, 0.8);
            position: relative;
            z-index: 2;
        }
        
        p a {
            color: #000000ff;
            text-decoration: none;
            font-weight: 600;
            position: relative;
            transition: all 0.3s ease;
        }
        
        p a::after {
            content: '';
            position: absolute;
            bottom: -2px;
            left: 0;
            width: 0;
            height: 2px;
            background: linear-gradient(90deg, #deec5dff, #4b94beff);
            transition: width 0.3s ease;
        }
        
        p a:hover::after {
            width: 100%;
        }
        
        @keyframes fadeIn {
            from { 
                opacity: 0; 
                transform: translateY(30px) scale(0.95); 
            }
            to { 
                opacity: 1; 
                transform: translateY(0) scale(1); 
            }
        }
        
        @media (max-width: 480px) {
            .container {
                padding: 32px 24px;
                margin: 20px;
            }
            
            .container h2 {
                font-size: 1.9em;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Welcome Back</h2>
    <p class="tagline">Log in to pick up your orders faster & hassle-free </p>
    <?php if(isset($error)) echo "<p class='error'>$error</p>"; ?>
    <form method="POST">
        <input type="email" name="email" placeholder="Email Address" required />
        <input type="password" name="password" placeholder="Password" required />
        <button type="submit" name="login">Login</button>
        <p>New user? <a href="register.php">Register here</a></p>
    </form>
</div>
</body>
</html>
