<?php session_start(); include 'db.php'; if(!isset($_SESSION['user_id'])) header('Location: login.php'); 
// Fetch categories 
$cats = $pdo->query("SELECT * FROM categories")->fetchAll(PDO::FETCH_ASSOC); 
// Fetch menu items 
$cat_id = isset($_GET['cat']) ? intval($_GET['cat']) : 0; 
if($cat_id>0){ 
    $stmt = $pdo->prepare("SELECT * FROM menu_items WHERE category_id=?"); 
    $stmt->execute([$cat_id]); 
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC); 
} else { 
    $items = $pdo->query("SELECT * FROM menu_items")->fetchAll(PDO::FETCH_ASSOC); 
} 
// Settings (logo & default pickup minutes) 
$settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC); 
$default_minutes = $settings['default_pickup_minutes']; 
?> 
<!DOCTYPE html> 
<html lang="en"> 
<head> 
    <meta charset="UTF-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1.0"> 
    <title>Menu</title> 
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
        /* Modern CSS Reset */
        * { 
            margin: 0; 
            padding: 0; 
            box-sizing: border-box; 
        }
        
        /* Color Variables - Same colors, more refined usage */
        :root {
            --primary: #deec5dff;
            --primary-light: #f5f8e5;
            --secondary: #7a93e6ff;
            --dark: #2d3748;
            --light: #f8f9fa;
            --accent: #deec5dff;
            --text: #2d3748;
            --gray: #a0aec0;
            --gray-light: #edf2f7;
            --border: #e2e8f0;
            --shadow-sm: 0 2px 6px rgba(0, 0, 0, 0.05);
            --shadow-md: 0 4px 12px rgba(0, 0, 0, 0.08);
            --shadow-lg: 0 10px 25px rgba(0, 0, 0, 0.12);
        }
        
        /* Body Styling */
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: var(--light);
            color: var(--text);
            line-height: 1.6;
            padding-bottom: 2rem;
        }
        
        /* Header Styling - More sophisticated */
        header {
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: white;
            padding: 1.8rem 0;
            text-align: center;
            box-shadow: var(--shadow-md);
            position: relative;
            overflow: hidden;
        }
        
        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 1.5rem;
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 1rem;
        }
        
        .restaurant-info {
            display: flex;
            flex-direction: column;
            align-items: center;
        }
        
        header img {
            height: 80px;
            width: 80px;
            border-radius: 50%;
            margin-bottom: 1rem;
            box-shadow: var(--shadow-lg);
            border: 3px solid white;
            object-fit: cover;
        }
        
        header h1 {
            font-size: 2.6rem;
            font-weight: 700;
            margin-bottom: 0.25rem;
            letter-spacing: 0.5px;
        }
        
        .tagline {
            font-style: italic;
            font-weight: 300;
            opacity: 0.9;
            margin-bottom: 0.5rem;
        }
        
        .header-divider {
            height: 2px;
            width: 60px;
            background: rgba(255, 255, 255, 0.5);
            margin: 0.5rem 0;
        }
        
        /* Container */
        .container {
            max-width: 1200px;
            margin: 2rem auto;
            padding: 0 1.5rem;
        }
        
        /* Category Navigation - More elegant */
        .category-nav {
            display: flex;
            overflow-x: auto;
            padding: 1rem 0;
            margin-bottom: 2rem;
            gap: 0.75rem;
            scrollbar-width: thin;
            scrollbar-color: var(--secondary) transparent;
        }
        
        .category-nav::-webkit-scrollbar {
            height: 4px;
        }
        
        .category-nav::-webkit-scrollbar-track {
            background: transparent;
            border-radius: 10px;
        }
        
        .category-nav::-webkit-scrollbar-thumb {
            background: var(--secondary);
            border-radius: 10px;
        }
        
        .category-nav a {
            flex: 0 0 auto;
            padding: 0.75rem 1.5rem;
            background: white;
            color: var(--dark);
            border-radius: 30px;
            text-decoration: none;
            font-weight: 600;
            box-shadow: var(--shadow-sm);
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 0.5rem;
            font-size: 0.95rem;
            border: 1px solid var(--border);
        }
        
        .category-nav a:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
            color: var(--secondary);
        }
        
        .category-nav a.active {
            background: var(--primary);
            color: var(--dark);
            box-shadow: 0 4px 12px rgba(222, 236, 93, 0.35);
        }
        
        /* Menu Grid */
        .menu-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 2rem;
            margin-bottom: 2.5rem;
        }
        
        /* Card Styling - More refined */
        .card {
            background: white;
            border-radius: 12px;
            overflow: hidden;
            box-shadow: var(--shadow-sm);
            transition: all 0.3s ease;
            display: flex;
            flex-direction: column;
            height: 100%;
            border: 1px solid var(--border);
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: var(--shadow-lg);
        }
        
        .card-image {
            position: relative;
            height: 200px;
            overflow: hidden;
        }
        
        .card-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            transition: transform 0.5s ease;
        }
        
        .card:hover .card-image img {
            transform: scale(1.05);
        }
        
        .card-badge {
            position: absolute;
            top: 15px;
            right: 15px;
            background: var(--accent);
            color: var(--dark);
            padding: 5px 12px;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.75rem;
            box-shadow: var(--shadow-sm);
        }
        
        .card-content {
            padding: 1.5rem;
            flex: 1;
            display: flex;
            flex-direction: column;
        }
        
        .card-title {
            font-size: 1.3rem;
            font-weight: 600;
            margin-bottom: 0.75rem;
            color: var(--dark);
        }
        
        .card-description {
            color: #666;
            margin-bottom: 1.25rem;
            flex: 1;
            font-size: 0.95rem;
            line-height: 1.5;
        }
        
        .card-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: auto;
        }
        
        .card-price {
            font-weight: 700;
            font-size: 1.4rem;
            color: var(--secondary);
        }
        
        .quantity-control {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }
        
        .quantity-btn {
            width: 32px;
            height: 32px;
            border-radius: 50%;
            border: none;
            background: var(--gray-light);
            color: var(--dark);
            font-weight: 600;
            cursor: pointer;
            transition: all 0.2s ease;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        
        .quantity-btn:hover {
            background: var(--secondary);
            color: white;
        }
        
        .quantity-input {
            width: 50px;
            text-align: center;
            padding: 0.4rem;
            border: 1px solid var(--border);
            border-radius: 8px;
            font-weight: 600;
            transition: border-color 0.3s ease;
        }
        
        .quantity-input:focus {
            outline: none;
            border-color: var(--secondary);
        }
        
        /* Order Actions - More polished */
        .order-actions {
            background: white;
            padding: 1.5rem;
            border-radius: 12px;
            box-shadow: var(--shadow-md);
            display: flex;
            flex-wrap: wrap;
            align-items: center;
            justify-content: space-between;
            gap: 1.5rem;
            margin-top: 2rem;
            border: 1px solid var(--border);
        }
        
        .pickup-time {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            font-weight: 600;
        }
        
        .pickup-input {
            padding: 0.6rem 0.8rem;
            border: 1px solid var(--border);
            border-radius: 8px;
            width: 80px;
            text-align: center;
            font-weight: 600;
            transition: border-color 0.3s ease;
        }
        
        .pickup-input:focus {
            outline: none;
            border-color: var(--secondary);
        }
        
        .order-btn {
            padding: 0.9rem 2.2rem;
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            color: var(--dark);
            border: none;
            border-radius: 30px;
            font-weight: 700;
            font-size: 1.05rem;
            cursor: pointer;
            transition: all 0.3s ease;
            box-shadow: 0 4px 12px rgba(122, 147, 230, 0.25);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        
        .order-btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 20px rgba(122, 147, 230, 0.35);
        }
        
        /* My Orders Link */
        .my-orders {
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            padding: 0.75rem 1.5rem;
            background: white;
            color: var(--dark);
            border-radius: 30px;
            text-decoration: none;
            font-weight: 600;
            margin-bottom: 2rem;
            box-shadow: var(--shadow-sm);
            transition: all 0.3s ease;
            border: 1px solid var(--border);
        }
        
        .my-orders:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
            color: var(--secondary);
        }
        
        /* Responsive Design */
        @media (max-width: 768px) {
            .menu-grid {
                grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
                gap: 1.5rem;
            }
            
            .order-actions {
                flex-direction: column;
                align-items: stretch;
            }
            
            header h1 {
                font-size: 2.2rem;
            }
            
            .header-content {
                padding: 0 1rem;
            }
        }
        
        @media (max-width: 480px) {
            .menu-grid {
                grid-template-columns: 1fr;
            }
            
            .category-nav a {
                padding: 0.6rem 1.2rem;
                font-size: 0.9rem;
            }
            
            .card-title {
                font-size: 1.2rem;
            }
            
            .container {
                padding: 0 1rem;
            }
        }
        
        /* Animation */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .menu-grid .card {
            animation: fadeIn 0.5s ease forwards;
        }
        
        .menu-grid .card:nth-child(2) { animation-delay: 0.1s; }
        .menu-grid .card:nth-child(3) { animation-delay: 0.2s; }
        .menu-grid .card:nth-child(4) { animation-delay: 0.3s; }
        .menu-grid .card:nth-child(5) { animation-delay: 0.4s; }
        .menu-grid .card:nth-child(6) { animation-delay: 0.5s; }
        
        /* Special labels */
        .special-label {
            display: inline-block;
            padding: 0.25rem 0.75rem;
            background: var(--primary);
            color: var(--dark);
            border-radius: 4px;
            font-size: 0.8rem;
            font-weight: 600;
            margin-top: 0.5rem;
        }
    </style>
</head> 
<body> 
    <header>
                       <nav>
            </nav>
        <div class="header-content">
        <a href="./home.php"> <img src="./logo.png"></a>   
            <h1>Our Menu</h1>
</a>

        </div>
    </header>
             
    <div class="container">
        <!-- Categories Navigation -->
        <div class="category-nav">
            <a href="menu.php" class="<?= $cat_id==0?'active':'' ?>">
                <i class="fas fa-th-large"></i> All Items
            </a>
            <?php foreach($cats as $c){ ?>
            <a href="menu.php?cat=<?= $c['id'] ?>" class="<?= ($cat_id==$c['id'])?'active':'' ?>">
                <i class="fas fa-<?= strtolower($c['name']) ?>"></i> <?= $c['name'] ?>
            </a>
            <?php } ?>
        </div>
        
        <a href="./my_orders.php" class="my-orders">
            <i class="fas fa-list-alt"></i> My Orders
        </a>
        
        <form method="POST" action="checkout.php">
            <div class="menu-grid">
                <?php foreach($items as $m){ ?>
                <div class="card">
                    <div class="card-image">
                        <img src="<?= $m['image'] ?>" alt="<?= $m['name'] ?>">
                        <div class="card-badge">Popular</div>
                    </div>
                    <div class="card-content">
                        <h3 class="card-title"><?= $m['name'] ?></h3>
                        <p class="card-description"><?= $m['description'] ?></p>
                        <div class="card-footer">
<div class="card-price"><?= number_format((float)$m['price'], 0) ?> IQD</div>
                            <div class="quantity-control">
                                <button type="button" class="quantity-btn minus" data-id="<?= $m['id'] ?>">-</button>
                                <input type="number" class="quantity-input" name="qty[<?= $m['id'] ?>]" value="0" min="0" data-id="<?= $m['id'] ?>">
                                <button type="button" class="quantity-btn plus" data-id="<?= $m['id'] ?>">+</button>
                            </div>
                        </div>
                    </div>
                </div>
                <?php } ?>
            </div>
            
<div class="order-actions">
    <div class="pickup-time">
        <i class="fas fa-clock"></i>
        <span>Pickup in minutes:</span>
        <input type="number" class="pickup-input" name="pickup_minutes" value="<?= $default_minutes ?>" min="15" max="120">
    </div>

    <div class="dinein-table" style="display:none; margin-left:20px;">
        <i class="fas fa-chair"></i>
        <span>Table Number:</span>
        <input type="number" name="table_number" min="1" placeholder="Enter table number">
    </div>

    <div style="margin-left:20px;">
        <label>
            <input type="radio" name="order_type" value="pickup" checked> Pickup
        </label>
        <label style="margin-left:10px;">
            <input type="radio" name="order_type" value="dinein"> Dine-in
        </label>
    </div>

    <button type="submit" class="order-btn">
        <i class="fas fa-shopping-cart"></i> Place Order
    </button>
</div>

        </form>
    </div>
    
    <script>
        // Quantity buttons functionality
        document.querySelectorAll('.quantity-btn').forEach(button => {
            button.addEventListener('click', function() {
                const id = this.getAttribute('data-id');
                const input = document.querySelector(`.quantity-input[data-id="${id}"]`);
                let value = parseInt(input.value);
                
                if (this.classList.contains('plus')) {
                    input.value = value + 1;
                } else if (this.classList.contains('minus') && value > 0) {
                    input.value = value - 1;
                }
            });
        });
    </script>
    <script>
    const orderTypeRadios = document.querySelectorAll('input[name="order_type"]');
    const tableInputDiv = document.querySelector('.dinein-table');

    orderTypeRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            if (this.value === 'dinein') {
                tableInputDiv.style.display = 'flex';
            } else {
                tableInputDiv.style.display = 'none';
            }
        });
    });
</script>

</body> 
</html>