<?php
session_start();
include 'db.php';
if(!isset($_SESSION['user_id'])) header('Location: login.php');

$user_id = $_SESSION['user_id'];
$orders = $pdo->prepare("SELECT * FROM orders WHERE user_id=? ORDER BY created_at DESC");
$orders->execute([$user_id]);
$orders = $orders->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>My Orders</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --primary: #deec5dff;
            --primary-light: #e0e6ff;
            --secondary: #7a93e6ff;
            --dark: #2d3748;
            --light: #f8f9fa;
            --success: #48bb78;
            --warning: #ecc94b;
            --gray: #a0aec0;
            --gray-light: #edf2f7;
            --border: #e2e8f0;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f5f7fb;
            color: var(--dark);
            line-height: 1.6;
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        header {
            background: linear-gradient(120deg, var(--primary), #6b8cff);
            color: white;
            padding: 25px 0;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.1);
            margin-bottom: 30px;
        }
        
        .header-content {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .logo {
            font-size: 24px;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .logo i {
            font-size: 28px;
        }
        
        nav a {
            color: white;
            text-decoration: none;
            margin-left: 20px;
            font-weight: 500;
            padding: 8px 16px;
            border-radius: 20px;
            transition: background 0.3s;
        }
        
        nav a:hover {
            background: rgba(255, 255, 255, 0.2);
        }
        
        .page-title {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 25px;
            color: var(--dark);
            display: flex;
            align-items: center;
            gap: 12px;
        }
        
        .page-title i {
            color: var(--primary);
        }
        
        .orders-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            overflow: hidden;
        }
        
        .order-card {
            border-bottom: 1px solid var(--border);
            padding: 20px;
            transition: background 0.3s;
        }
        
        .order-card:last-child {
            border-bottom: none;
        }
        
        .order-card:hover {
            background: var(--gray-light);
        }
        
        .order-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 15px;
        }
        
        .order-id {
            font-weight: 700;
            color: var(--primary);
            font-size: 18px;
        }
        
        .order-date {
            color: var(--gray);
            font-size: 14px;
        }
        
        .order-details {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 15px;
        }
        
        .detail-item {
            display: flex;
            flex-direction: column;
        }
        
        .detail-label {
            font-size: 12px;
            color: var(--gray);
            margin-bottom: 5px;
            text-transform: uppercase;
            font-weight: 600;
        }
        
        .detail-value {
            font-weight: 600;
            font-size: 16px;
        }
        
        .status-badge {
            display: inline-block;
            padding: 5px 12px;
            border-radius: 20px;
            font-size: 14px;
            font-weight: 600;
        }
        
        .status-pending {
            background: #fff8e1;
            color: #f57c00;
        }
        
        .status-preparing {
            background: #e3f2fd;
            color: #1976d2;
        }
        
        .status-ready {
            background: #e8f5e9;
            color: var(--success);
        }
        
        .status-completed {
            background: #f5f5f5;
            color: var(--dark);
        }
        
        .order-items {
            margin-top: 15px;
        }
        
        .items-title {
            font-weight: 600;
            margin-bottom: 10px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        
        .items-list {
            list-style: none;
        }
        
        .item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dashed var(--border);
        }
        
        .item:last-child {
            border-bottom: none;
        }
        
        .item-name {
            flex: 1;
        }
        
        .item-quantity {
            font-weight: 600;
            color: var(--primary);
            margin-right: 20px;
        }
        
        .item-price {
            font-weight: 600;
            color: var(--dark);
        }
        
        .empty-state {
            text-align: center;
            padding: 40px 20px;
            color: var(--gray);
        }
        
        .empty-state i {
            font-size: 60px;
            margin-bottom: 15px;
            color: var(--gray-light);
        }
        
        .empty-state p {
            font-size: 18px;
            margin-bottom: 20px;
        }
        
        .btn-primary {
            background: var(--primary);
            color: white;
            border: none;
            padding: 12px 24px;
            border-radius: 30px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
            text-decoration: none;
            display: inline-block;
        }
        
        .btn-primary:hover {
            background: #3a5be8;
        }
        
        @media (max-width: 768px) {
            .order-header {
                flex-direction: column;
                align-items: flex-start;
                gap: 10px;
            }
            
            .order-details {
                grid-template-columns: 1fr;
                gap: 15px;
            }
            
            .header-content {
                flex-direction: column;
                gap: 15px;
            }
            
            nav {
                display: flex;
                gap: 10px;
            }
            
            nav a {
                margin-left: 0;
            }
        }
    </style>
</head>
<body>
    <header>
        <div class="header-content">
            <div class="logo">
                <i class="fas fa-utensils"></i>
                <span>FoodExpress</span>
            </div>
            <nav>
                <a href="menu.php"><i class="fas fa-arrow-left"></i> Back to Menu</a>
                <a href="logout.php"><i class="fas fa-sign-out-alt"></i> Logout</a>
            </nav>
        </div>
    </header>
    
    <div class="container">
        <h1 class="page-title">
            <i class="fas fa-history"></i> Order History
        </h1>
        
        <div class="orders-container">
            <?php if (count($orders) > 0): ?>
                <?php foreach($orders as $o): 
                    $items = $pdo->prepare("SELECT oi.*, m.name, m.price FROM order_items oi JOIN menu_items m ON m.id=oi.menu_item_id WHERE order_id=?");
                    $items->execute([$o['id']]);
                    $items = $items->fetchAll(PDO::FETCH_ASSOC);
                    
                    // Determine status class
                    $statusClass = 'status-' . $o['status'];
                    if ($o['status'] == 'ready') {
                        $statusText = 'Ready for Pickup ✅';
                    } else {
                        $statusText = ucfirst($o['status']);
                    }
                ?>
                <div class="order-card">
                    <div class="order-header">
                        <div class="order-id">Order #<?= $o['id'] ?></div>
                        <div class="order-date"><?= date('M j, Y g:i A', strtotime($o['created_at'])) ?></div>
                    </div>
                    
                    <div class="order-details">
                        <div class="detail-item">
                            <span class="detail-label">Total Amount</span>
<span class="detail-value"><?= number_format((float)$o['total_price'], 0) ?> IQD</span>
                        </div>
                        
                        <div class="detail-item">
                            <span class="detail-label">Pickup Time</span>
                            <span class="detail-value"><?= date('g:i A', strtotime($o['pickup_time'])) ?></span>
                        </div>
                        
                        <div class="detail-item">
                            <span class="detail-label">Status</span>
                            <span class="status-badge <?= $statusClass ?>"><?= $statusText ?></span>
                        </div>
                    </div>
                    
                    <div class="order-items">
                        <div class="items-title">
                            <i class="fas fa-receipt"></i> Items Ordered
                        </div>
                        <ul class="items-list">
                            <?php foreach($items as $i): ?>
                            <li class="item">
                                <span class="item-name"><?= $i['name'] ?></span>
                                <span class="item-quantity">x<?= $i['quantity'] ?></span>
<span class="item-price"><?= number_format((float)$i['price'] * $i['quantity'], 0) ?> IQD</span>
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div class="empty-state">
                    <i class="fas fa-clipboard-list"></i>
                    <p>You haven't placed any orders yet.</p>
                    <a href="menu.php" class="btn-primary">Browse Menu</a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>