<?php
session_start();
include 'db.php';
if(!isset($_SESSION['user_id'])) header('Location: login.php');
if(!isset($_GET['id'])) die("Order ID missing");

$order_id = intval($_GET['id']);
$user_id = $_SESSION['user_id'];

// Fetch order
$stmt = $pdo->prepare("SELECT * FROM orders WHERE id=? AND user_id=?");
$stmt->execute([$order_id,$user_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);
if(!$order) die("Order not found");

// Fetch items
$stmt = $pdo->prepare("SELECT oi.*, m.name, m.image FROM order_items oi JOIN menu_items m ON oi.menu_item_id=m.id WHERE oi.order_id=?");
$stmt->execute([$order_id]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Order Confirmed - FoodExpress</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
              --primary: #deec5dff;
            --primary-light: #e0e6ff;
            --secondary: #7a93e6ff;
            --dark: #2d3748;
            --light: #f8f9fa;
            --success: #48bb78;
            --warning: #ecc94b;
            --gray: #a0aec0;
            --gray-light: #edf2f7;
            --border: #e2e8f0;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body {
            background-color: #f5f7fb;
            color: var(--dark);
            line-height: 1.6;
            padding: 20px;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
        }
        
        .confirmation-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
            width: 100%;
            max-width: 800px;
            overflow: hidden;
            margin: 20px 0;
        }
        
        .confirmation-header {
            background: linear-gradient(120deg, var(--primary), #6b8cff);
            color: white;
            padding: 30px;
            text-align: center;
            position: relative;
            overflow: hidden;
        }
        
        .confirmation-header::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" preserveAspectRatio="none"><path d="M0,0 L100,0 L100,100 Z" fill="rgba(255,255,255,0.1)"/></svg>');
            background-size: 100% 100%;
        }
        
        .confirmation-header-content {
            position: relative;
            z-index: 2;
        }
        
        .confirmation-icon {
            font-size: 60px;
            margin-bottom: 15px;
            color: rgba(255, 255, 255, 0.9);
        }
        
        .confirmation-title {
            font-size: 32px;
            font-weight: 700;
            margin-bottom: 10px;
        }
        
        .confirmation-subtitle {
            font-size: 18px;
            opacity: 0.9;
        }
        
        .confirmation-body {
            padding: 30px;
        }
        
        .order-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
            padding: 20px;
            background: var(--gray-light);
            border-radius: 12px;
        }
        
        .info-item {
            display: flex;
            flex-direction: column;
        }
        
        .info-label {
            font-size: 14px;
            color: var(--gray);
            margin-bottom: 5px;
            font-weight: 600;
        }
        
        .info-value {
            font-size: 18px;
            font-weight: 600;
            color: var(--dark);
        }
        
        .status-badge {
            display: inline-block;
            padding: 8px 16px;
            border-radius: 20px;
            font-weight: 600;
            background: var(--primary-light);
            color: var(--primary);
        }
        
        .items-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid var(--border);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        
        .items-list {
            list-style: none;
        }
        
        .item {
            display: flex;
            align-items: center;
            padding: 15px;
            border-radius: 12px;
            margin-bottom: 15px;
            background: var(--gray-light);
            transition: transform 0.2s, box-shadow 0.2s;
        }
        
        .item:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.05);
        }
        
        .item-image {
            width: 80px;
            height: 80px;
            border-radius: 10px;
            overflow: hidden;
            margin-right: 20px;
            flex-shrink: 0;
        }
        
        .item-image img {
            width: 100%;
            height: 100%;
            object-fit: cover;
        }
        
        .item-details {
            flex: 1;
        }
        
        .item-name {
            font-weight: 600;
            font-size: 18px;
            margin-bottom: 5px;
        }
        
        .item-meta {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .item-quantity {
            font-weight: 600;
            color: var(--primary);
        }
        
        .item-price {
            font-weight: 700;
            font-size: 18px;
            color: var(--dark);
        }
        
        .order-summary {
            background: var(--gray-light);
            padding: 20px;
            border-radius: 12px;
            margin-top: 30px;
        }
        
        .summary-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid var(--border);
        }
        
        .summary-row:last-child {
            border-bottom: none;
        }
        
        .summary-label {
            font-weight: 600;
        }
        
        .summary-value {
            font-weight: 700;
        }
        
        .total-row {
            font-size: 20px;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px dashed var(--border);
        }
        
        .action-buttons {
            display: flex;
            justify-content: center;
            gap: 15px;
            margin-top: 30px;
            flex-wrap: wrap;
        }
        
        .btn {
            padding: 14px 28px;
            border-radius: 30px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 8px;
            transition: all 0.3s;
            border: none;
            cursor: pointer;
            font-size: 16px;
        }
        
        .btn-primary {
            background: var(--primary);
            color: white;
        }
        
        .btn-primary:hover {
            background: #3a5be8;
            transform: translateY(-2px);
            box-shadow: 0 6px 15px rgba(74, 108, 250, 0.3);
        }
        
        .btn-outline {
            background: transparent;
            color: var(--primary);
            border: 2px solid var(--primary);
        }
        
        .btn-outline:hover {
            background: var(--primary-light);
            transform: translateY(-2px);
        }
        
        @media (max-width: 768px) {
            .confirmation-header {
                padding: 20px;
            }
            
            .confirmation-title {
                font-size: 26px;
            }
            
            .confirmation-body {
                padding: 20px;
            }
            
            .order-info {
                grid-template-columns: 1fr;
            }
            
            .item {
                flex-direction: column;
                text-align: center;
            }
            
            .item-image {
                margin-right: 0;
                margin-bottom: 15px;
            }
            
            .item-meta {
                flex-direction: column;
                gap: 10px;
            }
            
            .action-buttons {
                flex-direction: column;
            }
            
            .btn {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
</head>
<body>
    <div class="confirmation-container">
        <div class="confirmation-header">
            <div class="confirmation-header-content">
                <div class="confirmation-icon">
                    <i class="fas fa-check-circle"></i>
                </div>
                <h1 class="confirmation-title">Order Confirmed!</h1>
                <p class="confirmation-subtitle">Thank you for your order. We're preparing it now.</p>
            </div>
        </div>
        
        <div class="confirmation-body">
            <div class="order-info">
                <div class="info-item">
                    <span class="info-label">Order ID</span>
                    <span class="info-value">#<?= $order['id'] ?></span>
                </div>
                
                <div class="info-item">
                    <span class="info-label">Pickup Time</span>
                    <span class="info-value"><?= date('g:i A - M j, Y', strtotime($order['pickup_time'])) ?></span>
                </div>
                
                <div class="info-item">
                    <span class="info-label">Payment Method</span>
                    <span class="info-value"><?= strtoupper($order['payment_method']) ?></span>
                </div>
                
                <div class="info-item">
                    <span class="info-label">Status</span>
                    <span class="status-badge"><?= ucfirst($order['status']) ?></span>
                </div>
            </div>
            
            <h2 class="items-title">
                <i class="fas fa-receipt"></i> Order Details
            </h2>
            
            <ul class="items-list">
                <?php foreach($items as $i): ?>
                <li class="item">
                    <div class="item-image">
                        <img src="<?= $i['image'] ?>" alt="<?= htmlspecialchars($i['name']) ?>">
                    </div>
                    <div class="item-details">
                        <h3 class="item-name"><?= htmlspecialchars($i['name']) ?></h3>
                        <div class="item-meta">
                            <span class="item-quantity">Quantity: <?= $i['quantity'] ?></span>
                            <span class="item-price"><?= number_format($i['price'] * $i['quantity'], 0) ?> IQD</span>
                        </div>
                    </div>
                </li>
                <?php endforeach; ?>
            </ul>
            
            <div class="order-summary">
                <div class="summary-row">
                    <span class="summary-label">Subtotal</span>
                    <span class="summary-value"><?= number_format($order['total_price'], 0) ?> IQD</span>
                </div>
                <div class="summary-row">
                    <span class="summary-label">Tax</span>
                    <span class="summary-value">0 IQD</span>
                </div>
                <div class="summary-row total-row">
                    <span class="summary-label">Total</span>
                    <span class="summary-value"><?= number_format($order['total_price'], 0) ?> IQD</span>
                </div>
            </div>
            
            <div class="action-buttons">
                <a href="menu.php" class="btn btn-primary">
                    <i class="fas fa-utensils"></i> Order Again
                </a>
                <a href="my_orders.php" class="btn btn-outline">
                    <i class="fas fa-history"></i> View All Orders
                </a>
            </div>
        </div>
    </div>
</body>
</html>