<?php
session_start();
include 'db.php';

if(!isset($_SESSION['user_id'])) header('Location: login.php');
if(!isset($_SESSION['checkout'])) header('Location: menu.php');

$checkout = $_SESSION['checkout'];
$items_ordered = $checkout['items'];
$total = $checkout['total'];
$order_type = $checkout['order_type'];
$table_number = $checkout['table_number'] ?? null;

if($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = $_SESSION['user_id'];
    $payment_method = $_POST['payment_method'];
    $upload_file = '';

    if($payment_method == 'fib' && isset($_FILES['fib']) && $_FILES['fib']['name'] != ''){
        if(!is_dir('uploads')) mkdir('uploads', 0777, true);
        $upload_file = 'uploads/'.basename($_FILES['fib']['name']);
        move_uploaded_file($_FILES['fib']['tmp_name'], $upload_file);
    }

    $pickup_minutes = $checkout['pickup_minutes'] ?? 15;
    $pickup_time = date('Y-m-d H:i:s', strtotime("+$pickup_minutes minutes"));

    $stmt = $pdo->prepare("INSERT INTO orders(user_id, total_price, pickup_time, payment_method, order_type, table_number, status, created_at) VALUES(?,?,?,?,?,?,?,NOW())");
    $status = ($payment_method === 'cash') ? 'pending' : 'awaiting_payment';
    $stmt->execute([$user_id, $total, $pickup_time, $payment_method, $order_type, $table_number, $status]);
    $order_id = $pdo->lastInsertId();

    $stmt_item = $pdo->prepare("INSERT INTO order_items(order_id, menu_item_id, item_name, quantity, price) VALUES(?,?,?,?,?)");
    foreach($items_ordered as $oi){
        $stmt_item->execute([$order_id, $oi['id'], $oi['name'], $oi['qty'], $oi['price']]);
    }

    if($payment_method == 'fib'){
        $stmt = $pdo->prepare("INSERT INTO payments(order_id,user_id,photo,status) VALUES(?,?,?,?)");
        $stmt->execute([$order_id, $user_id, $upload_file, 'pending']);
    }

    unset($_SESSION['checkout']);
    header("Location: order_confirm.php?id=$order_id");
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Payment - Modern POS</title>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
:root {
    --primary: #3a86ff;
    --primary-light: #edf4ff;
    --secondary: #8338ec;
    --accent: #ff006e;
    --dark: #1d1d1d;
    --light: #f9f9f9;
    --gray: #8a8a8a;
    --border: #e0e0e0;
    --shadow-sm: 0 2px 6px rgba(0,0,0,0.05);
    --shadow-md: 0 4px 12px rgba(0,0,0,0.08);
    --shadow-lg: 0 10px 25px rgba(0,0,0,0.12);
    --transition: all 0.3s ease;
}
* {margin:0;padding:0;box-sizing:border-box;font-family:'Segoe UI',sans-serif;}
body {background:var(--light); display:flex; justify-content:center; align-items:flex-start; min-height:100vh; padding:20px;}
.payment-container {width:100%; max-width:480px; background:white; border-radius:12px; box-shadow:var(--shadow-lg); overflow:hidden; transform:translateY(-20px); opacity:0; animation:fadeIn 0.5s forwards;}
@keyframes fadeIn {to {transform:translateY(0); opacity:1;}}
.payment-header {background:var(--primary); color:white; text-align:center; padding:20px; position:relative;}
.payment-header h1 {font-size:22px; margin-bottom:5px;}
.payment-header p {font-size:14px; opacity:0.9;}
.payment-body {padding:20px;}
.order-summary {background:var(--primary-light); border-radius:10px; padding:15px; margin-bottom:20px; transition:var(--transition);}
.order-summary:hover {box-shadow:var(--shadow-md);}
.order-summary h3 {font-size:16px; margin-bottom:10px; display:flex; align-items:center; gap:6px; color:var(--dark);}
.summary-item {display:flex; justify-content:space-between; font-size:14px; margin-bottom:6px;}
.summary-total {display:flex; justify-content:space-between; font-weight:700; font-size:16px; border-top:1px dashed var(--border); padding-top:8px; margin-top:8px; color:var(--primary);}
.payment-options {display:flex; flex-direction:column; gap:12px; margin-bottom:20px;}
.payment-option {position:relative; transition:var(--transition);}
.payment-option input[type="radio"] {position:absolute; opacity:0;}
.payment-option-label {display:flex; align-items:center; padding:12px 15px; border:2px solid var(--border); border-radius:8px; cursor:pointer; transition:var(--transition); background:white; box-shadow:var(--shadow-sm);}
.payment-option input[type="radio"]:checked + .payment-option-label {border-color:var(--secondary); background:linear-gradient(90deg, var(--primary-light), #fff);}
.payment-option-label:hover {transform:scale(1.02);}
.payment-option-icon {margin-right:12px; font-size:20px; color:var(--secondary); width:25px; text-align:center;}
.payment-option-details {flex:1;}
.payment-option-title {font-weight:600; margin-bottom:2px; color:var(--dark);}
.payment-option-description {font-size:13px; color:var(--gray);}
.file-upload {margin-top:10px; padding:10px; border:2px dashed var(--border); border-radius:8px; text-align:center; display:none; transition:var(--transition);}
.file-upload.active {display:block; border-color:var(--secondary);}
.file-upload-label {cursor:pointer; display:flex; flex-direction:column; align-items:center; gap:6px; transition:var(--transition);}
.file-upload-icon {font-size:24px; color:var(--secondary);}
.file-upload-text {font-size:13px; color:var(--gray);}
.btn {width:100%; padding:12px; border:none; border-radius:8px; font-weight:600; background:var(--secondary); color:white; cursor:pointer; font-size:15px; transition:var(--transition);}
.btn:hover {background:#6a2cb3; transform:translateY(-2px);}
@media(max-width:480px){.payment-container{padding:0;margin:0;} .payment-header h1{font-size:20px;}}
</style>
</head>
<body>
<div class="payment-container">
    <div class="payment-header">
        <h1>Payment Method</h1>
        <p>Choose how you'd like to pay</p>
    </div>
    <div class="payment-body">
        <div class="order-summary">
            <h3><i class="fas fa-receipt"></i> Order Summary</h3>
            <?php foreach($items_ordered as $item): ?>
                <div class="summary-item">
                    <span><?= htmlspecialchars($item['name']) ?> x<?= $item['qty'] ?></span>
                    <span>IQD <?= number_format($item['price'] * $item['qty'],2) ?></span>
                </div>
            <?php endforeach; ?>
            <div class="summary-total">
                <span>Total</span>
                <span>IQD <?= number_format($total,2) ?></span>
            </div>
        </div>
        <form method="POST" enctype="multipart/form-data" id="paymentForm">
            <div class="payment-options">
                <div class="payment-option">
                    <input type="radio" id="cash" name="payment_method" value="cash" checked>
                    <label for="cash" class="payment-option-label">
                        <div class="payment-option-icon"><i class="fas fa-money-bill-wave"></i></div>
                        <div class="payment-option-details">
                            <div class="payment-option-title">Cash on Pickup</div>
                            <div class="payment-option-description">Pay with cash when you collect your order</div>
                        </div>
                    </label>
                </div>
                <div class="payment-option">
                    <input type="radio" id="fib" name="payment_method" value="fib">
                    <label for="fib" class="payment-option-label">
                        <div class="payment-option-icon"><i class="fas fa-building"></i></div>
                        <div class="payment-option-details">
                            <div class="payment-option-title">Bank Transfer</div>
                            <div class="payment-option-description">Upload proof of bank transfer</div>
                        </div>
                    </label>
                </div>
            </div>
            <div class="file-upload" id="fileUpload">
                <label class="file-upload-label" for="fibFile">
                    <div class="file-upload-icon"><i class="fas fa-cloud-upload-alt"></i></div>
                    <div class="file-upload-text">Click to upload proof of transfer</div>
                    <input type="file" id="fibFile" name="fib" accept="image/*">
                </label>
            </div>
            <button type="submit" class="btn"><i class="fas fa-check-circle"></i> Confirm Order</button>
        </form>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function(){
    const cashOption = document.getElementById('cash');
    const fibOption = document.getElementById('fib');
    const fileUpload = document.getElementById('fileUpload');
    const fibFile = document.getElementById('fibFile');

    function toggleFileUpload() {
        if(fibOption.checked) fileUpload.classList.add('active');
        else fileUpload.classList.remove('active');
    }
    toggleFileUpload();
    cashOption.addEventListener('change', toggleFileUpload);
    fibOption.addEventListener('change', toggleFileUpload);

    fibFile.addEventListener('change', function(){
        if(this.files && this.files[0]){
            document.querySelector('.file-upload-text').textContent = this.files[0].name;
        }
    });

    document.getElementById('paymentForm').addEventListener('submit', function(e){
        if(fibOption.checked && !fibFile.value){
            e.preventDefault();
            alert('Please upload proof of bank transfer');
            fileUpload.style.borderColor='red';
        }
    });
});
</script>
</body>
</html>
