<?php
require 'db.php';

if (!isset($_GET['order_id'])) {
    die("Order ID is required.");
}

$order_id = intval($_GET['order_id']);

// Fetch order with user + restaurant info
$stmt = $pdo->prepare("
    SELECT o.*, u.name AS user_name, u.email, u.phone,
           r.name AS restaurant_name, r.address, r.phone AS restaurant_phone, r.logo
    FROM orders o
    JOIN users u ON o.user_id = u.id
    LEFT JOIN restaurants r ON o.restaurant_id = r.id
    WHERE o.id = ?
");
$stmt->execute([$order_id]);
$order = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$order) {
    die("Order not found.");
}

// Fetch order items
$stmt = $pdo->prepare("SELECT * FROM order_items WHERE order_id = ?");
$stmt->execute([$order_id]);
$items = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Invoice #<?= $order['id'] ?></title>
<style>
    body { font-family: Arial, sans-serif; background: #fff; margin:0; padding:20px; }
    .invoice-box { width: 100%; max-width: 800px; margin:auto; padding:20px; border:1px solid #eee; box-shadow: 0 4px 12px rgba(0,0,0,0.1);}
    .logo { text-align:center; margin-bottom:10px; }
    .logo img { max-height: 80px; }
    h2 { margin:0; text-align:center; }
    .info { margin:15px 0; font-size:14px; }
    table { width:100%; border-collapse:collapse; margin-top:20px; font-size:14px;}
    th, td { border:1px solid #ddd; padding:8px; text-align:left; }
    th { background:#f4f6f9; }
    .total { font-weight:bold; font-size:16px; }
    .footer { margin-top:20px; text-align:center; font-size:12px; color:#777; }

    /* POS receipt style */
    @media print {
        body { margin:0; padding:0; }
        .pos-receipt { width:58mm; font-size:12px; border:none; box-shadow:none; }
        .pos-receipt table, .pos-receipt th, .pos-receipt td { border:none; }
        .pos-receipt h2 { font-size:14px; margin:5px 0; }
        .pos-receipt .total { font-size:14px; }
        .btns { display:none; }
    }

    .btns { margin:15px 0; text-align:center; }
    .btns button { padding:10px 15px; margin:5px; border:none; border-radius:6px; cursor:pointer; font-weight:bold;}
    .btns .pos { background:#2d3748; color:white; }
    .btns .a4 { background:#7a93e6; color:white; }
</style>
<script>
function printPOS() {
    document.querySelector('.invoice-box').classList.add('pos-receipt');
    window.print();
    setTimeout(() => document.querySelector('.invoice-box').classList.remove('pos-receipt'), 500);
}
function printA4() {
    document.querySelector('.invoice-box').classList.remove('pos-receipt');
    window.print();
}
</script>
</head>
<body>
<div class="invoice-box">
    <div class="logo">
        <?php if (!empty($order['logo'])): ?>
            <img src="<?= htmlspecialchars($order['logo']) ?>" alt="Logo">
        <?php else: ?>
            <h2><?= htmlspecialchars($order['restaurant_name'] ?? "Restaurant") ?></h2>
        <?php endif; ?>
    </div>

    <h2>Invoice / فاتورة #<?= $order['id'] ?></h2>

    <div class="info">
        <b>Customer / الزبون:</b> <?= htmlspecialchars($order['user_name']) ?><br>
        <b>Phone / هاتف:</b> <?= htmlspecialchars($order['phone']) ?><br>
        <b>Email / ايميل:</b> <?= htmlspecialchars($order['email']) ?><br>
        <b>Date / التاريخ:</b> <?= $order['created_at'] ?><br>
        <b>Payment Method / طريقة الدفع:</b> <?= ucfirst($order['payment_method']) ?><br>
        <b>Order Type / نوع الطلب:</b> <?= $order['order_type'] == 'pickup' ? 'Pickup / استلام' : 'Dine-in / جلوس (Table ' . $order['table_number'] . ')' ?><br>
    </div>

    <table>
        <tr>
            <th>Item / الصنف</th>
            <th>Qty / العدد</th>
            <th>Price / السعر</th>
            <th>Total / المجموع</th>
        </tr>
        <?php 
        $grand = 0;
        foreach ($items as $i): 
            $qty = $i['quantity'] > 0 ? $i['quantity'] : $i['qty']; 
            $line = $qty * $i['price'];
            $grand += $line;
        ?>
        <tr>
            <td><?= htmlspecialchars($i['item_name']) ?></td>
            <td><?= $qty ?></td>
            <td><?= number_format($i['price'], 2) ?></td>
            <td><?= number_format($line, 2) ?></td>
        </tr>
        <?php endforeach; ?>
        <tr>
            <td colspan="3" class="total">Grand Total / المجموع</td>
            <td class="total"><?= number_format($grand, 2) ?></td>
        </tr>
    </table>

    <div class="footer">شكراً لتسوقك معنا / Thank you for your order!</div>
</div>

<div class="btns">
    <button class="pos" onclick="printPOS()">🖨 Print POS</button>
    <button class="a4" onclick="printA4()">🖨 Print A4</button>
</div>
</body>
</html>
