<?php
session_start();
include 'db.php';

if(isset($_POST['register'])){
    $name = $_POST['name'];
    $email = $_POST['email'];
    $phone = $_POST['phone'];
    $password = password_hash($_POST['password'], PASSWORD_DEFAULT);

    // Check if email already exists
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email=?");
    $stmt->execute([$email]);
    if($stmt->rowCount()>0){
        $error = "Email already registered";
    } else {
        $stmt = $pdo->prepare("INSERT INTO users(name,email,phone,password) VALUES(?,?,?,?)");
        $stmt->execute([$name,$email,$phone,$password]);
        $_SESSION['user_id'] = $pdo->lastInsertId();
        header('Location: menu.php');
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<title>Register</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(135deg, #fef9f4, #fdf1d6);
            margin: 0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            color: #56b3c4ff;
        }
        .container {
            max-width: 400px;
            width: 90%;
            padding: 25px;
            background: #fff;
            border-radius: 12px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.15);
            text-align: center;
            animation: fadeIn 0.7s ease-in-out;
        }
        .container h2 {
            margin-bottom: 8px;
            font-size: 1.8em;
            color: #56b3c4ff;
        }
        .tagline {
            font-size: 0.95em;
            color: #deec5dff;
            margin-bottom: 20px;
        }
        input {
            width: 100%;
            padding: 12px;
            margin: 10px 0;
            border: 1px solid #ddd;
            border-radius: 8px;
            font-size: 0.95em;
            outline: none;
            transition: border 0.3s ease;
            box-sizing: border-box;
        }
        input:focus {
            border-color: #deec5dff;
            box-shadow: 0 0 5px rgba(165,124,82,0.3);
        }
        button {
            width: 100%;
            padding: 12px;
            background: linear-gradient(90deg, #56b3c4ff, #a57c52);
            color: #fff;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            font-size: 1em;
            font-weight: bold;
            transition: transform 0.2s ease, opacity 0.2s ease;
        }
        button:hover {
            opacity: 0.9;
            transform: translateY(-2px);
        }
        .error {
            color: #d9534f;
            margin-bottom: 12px;
            font-size: 0.9em;
            display: none;
        }
        p {
            margin-top: 15px;
            font-size: 0.9em;
        }
        p a {
            color: #a57c52;
            text-decoration: none;
            font-weight: 600;
        }
        p a:hover {
            text-decoration: underline;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
<div class="container">
    <h2>Create Your Account</h2>
    <p class="tagline">Sign up today and make your order pickups quicker than ever </p>
    <?php if(isset($error)) echo "<p class='error'>$error</p>"; ?>
    <form method="POST">
        <input type="text" name="name" placeholder="Full Name" required />
        <input type="email" name="email" placeholder="Email Address" required />
        <input type="text" name="phone" placeholder="Phone Number" required />
        <input type="password" name="password" placeholder="Password" required />
        <button type="submit" name="register">Register</button>
        <p>Already registered? <a href="login.php">Login here</a></p>
    </form>
</div>
</body>
</html>
