<?php
require_once __DIR__ . '/../functions/auth.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../db/connection.php';
require_admin();
$restaurant_id = current_restaurant_id();
if (($_SESSION['role'] ?? '') === 'super' && get('restaurant_id')) $restaurant_id = (int)get('restaurant_id');

if (!$restaurant_id) die('Restaurant not selected.');

// Create/Update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && csrf_check(post('csrf'))) {
    $id = post('id');
    $name_en = post('name_en'); $name_ar = post('name_ar'); $name_ku = post('name_ku');
    if ($id) {
        $pdo->prepare('UPDATE categories SET name_en=?, name_ar=?, name_ku=? WHERE id=? AND restaurant_id=?')
            ->execute([$name_en, $name_ar, $name_ku, $id, $restaurant_id]);
    } else {
        $pdo->prepare('INSERT INTO categories (restaurant_id, name_en, name_ar, name_ku, created_at) VALUES (?,?,?,?,NOW())')
            ->execute([$restaurant_id, $name_en, $name_ar, $name_ku]);
    }
    redirect('categories.php');
}

if (get('delete')) {
    $pdo->prepare('DELETE FROM categories WHERE id=? AND restaurant_id=?')->execute([get('delete'), $restaurant_id]);
    redirect('categories.php');
}

$cats = $pdo->prepare('SELECT * FROM categories WHERE restaurant_id=? ORDER BY id DESC');
$cats->execute([$restaurant_id]);
$cats = $cats->fetchAll();

$edit = null;
if (get('edit')) {
    $stmt = $pdo->prepare('SELECT * FROM categories WHERE id=? AND restaurant_id=?');
    $stmt->execute([get('edit'), $restaurant_id]);
    $edit = $stmt->fetch();
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Categories</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="menu.php">Menu</a>
    <a href="orders.php">Orders</a>
    <a href="finances.php">Finances</a>
    <a href="tables.php">Tables</a>
    <a href="logout.php">Logout</a>
</nav>
<h1>Categories</h1>

<form method="post">
    <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>">
    <input type="hidden" name="id" value="<?php echo e($edit['id'] ?? ''); ?>">
    <div class="form-row"><label>Name (EN) <input type="text" name="name_en" value="<?php echo e($edit['name_en'] ?? ''); ?>" required></label></div>
    <div class="form-row"><label>Name (AR) <input type="text" name="name_ar" value="<?php echo e($edit['name_ar'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Name (KU) <input type="text" name="name_ku" value="<?php echo e($edit['name_ku'] ?? ''); ?>"></label></div>
    <button type="submit">Save</button>
</form>

<table>
<tr><th>ID</th><th>Name EN</th><th>Name AR</th><th>Name KU</th><th>Actions</th></tr>
<?php foreach ($cats as $c): ?>
<tr>
    <td><?php echo e($c['id']); ?></td>
    <td><?php echo e($c['name_en']); ?></td>
    <td><?php echo e($c['name_ar']); ?></td>
    <td><?php echo e($c['name_ku']); ?></td>
    <td>
        <a href="?edit=<?php echo e($c['id']); ?>">Edit</a> |
        <a href="?delete=<?php echo e($c['id']); ?>" onclick="return confirm('Delete category?')">Delete</a>
    </td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
