<?php
require_once __DIR__ . '/../functions/auth.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../functions/finances.php';
require_admin();
$restaurant_id = current_restaurant_id();
if (($_SESSION['role'] ?? '') === 'super' && get('restaurant_id')) $restaurant_id = (int)get('restaurant_id');
if (!$restaurant_id) die('Restaurant not selected.');

$summary = restaurant_finance_summary($restaurant_id);
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Finances</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="categories.php">Categories</a>
    <a href="menu.php">Menu</a>
    <a href="orders.php">Orders</a>
    <a href="tables.php">Tables</a>
    <a href="logout.php">Logout</a>
</nav>
<h1>Finance Summary</h1>
<table>
<tr><th>Orders</th><th>Gross</th><th>Commission</th><th>Net</th><th>Paid</th><th>Unpaid</th></tr>
<tr>
    <td><?php echo e($summary['orders_count']); ?></td>
    <td><?php echo number_format($summary['gross'],2); ?></td>
    <td><?php echo number_format($summary['commission'],2); ?></td>
    <td><?php echo number_format($summary['net'],2); ?></td>
    <td><?php echo e($summary['paid_count']); ?></td>
    <td><?php echo e($summary['unpaid_count']); ?></td>
</tr>
</table>
</body></html>
