<?php
require_once __DIR__ . '/../functions/auth.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../db/connection.php';
require_admin();
$restaurant_id = current_restaurant_id();
if (($_SESSION['role'] ?? '') === 'super' && get('restaurant_id')) $restaurant_id = (int)get('restaurant_id');
if (!$restaurant_id) die('Restaurant not selected.');

$cats = $pdo->prepare('SELECT id, name_en FROM categories WHERE restaurant_id=? ORDER BY name_en');
$cats->execute([$restaurant_id]);
$cats = $cats->fetchAll();

if ($_SERVER['REQUEST_METHOD'] === 'POST' && csrf_check(post('csrf'))) {
    $id = post('id');
    $name_en = post('name_en'); $name_ar = post('name_ar'); $name_ku = post('name_ku');
    $desc_en = post('desc_en'); $desc_ar = post('desc_ar'); $desc_ku = post('desc_ku');
    $price = (float)post('price');
    $category_id = (int)post('category_id');
    if ($id) {
        $pdo->prepare('UPDATE menu_items SET name_en=?, name_ar=?, name_ku=?, desc_en=?, desc_ar=?, desc_ku=?, price=?, category_id=? WHERE id=? AND restaurant_id=?')
            ->execute([$name_en,$name_ar,$name_ku,$desc_en,$desc_ar,$desc_ku,$price,$category_id,$id,$restaurant_id]);
    } else {
        $pdo->prepare('INSERT INTO menu_items (restaurant_id, category_id, name_en, name_ar, name_ku, desc_en, desc_ar, desc_ku, price, created_at) VALUES (?,?,?,?,?,?,?,?,?,NOW())')
            ->execute([$restaurant_id,$category_id,$name_en,$name_ar,$name_ku,$desc_en,$desc_ar,$desc_ku,$price]);
    }
    redirect('menu.php');
}

if (get('delete')) {
    $pdo->prepare('DELETE FROM menu_items WHERE id=? AND restaurant_id=?')->execute([get('delete'), $restaurant_id]);
    redirect('menu.php');
}

$items = $pdo->prepare('SELECT m.*, c.name_en as category_name FROM menu_items m LEFT JOIN categories c ON m.category_id=c.id WHERE m.restaurant_id=? ORDER BY m.id DESC');
$items->execute([$restaurant_id]);
$items = $items->fetchAll();

$edit = null;
if (get('edit')) {
    $stmt = $pdo->prepare('SELECT * FROM menu_items WHERE id=? AND restaurant_id=?');
    $stmt->execute([get('edit'), $restaurant_id]);
    $edit = $stmt->fetch();
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Menu</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="categories.php">Categories</a>
    <a href="orders.php">Orders</a>
    <a href="finances.php">Finances</a>
    <a href="tables.php">Tables</a>
    <a href="logout.php">Logout</a>
</nav>
<h1>Menu Items</h1>

<form method="post">
    <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>">
    <input type="hidden" name="id" value="<?php echo e($edit['id'] ?? ''); ?>">
    <div class="form-row"><label>Name (EN) <input type="text" name="name_en" required value="<?php echo e($edit['name_en'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Name (AR) <input type="text" name="name_ar" value="<?php echo e($edit['name_ar'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Name (KU) <input type="text" name="name_ku" value="<?php echo e($edit['name_ku'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Description (EN) <input type="text" name="desc_en" value="<?php echo e($edit['desc_en'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Description (AR) <input type="text" name="desc_ar" value="<?php echo e($edit['desc_ar'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Description (KU) <input type="text" name="desc_ku" value="<?php echo e($edit['desc_ku'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Price <input type="number" step="0.01" name="price" required value="<?php echo e($edit['price'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Category
        <select name="category_id" required>
            <?php foreach ($cats as $c): ?>
                <option value="<?php echo e($c['id']); ?>" <?php echo (($edit['category_id'] ?? '')==$c['id'])?'selected':''; ?>><?php echo e($c['name_en']); ?></option>
            <?php endforeach; ?>
        </select>
    </label></div>
    <button type="submit">Save</button>
</form>

<table>
<tr><th>ID</th><th>Name</th><th>Category</th><th>Price</th><th>Actions</th></tr>
<?php foreach ($items as $i): ?>
<tr>
    <td><?php echo e($i['id']); ?></td>
    <td><?php echo e($i['name_en']); ?></td>
    <td><?php echo e($i['category_name']); ?></td>
    <td><?php echo number_format($i['price'],2); ?></td>
    <td>
        <a href="?edit=<?php echo e($i['id']); ?>">Edit</a> |
        <a href="?delete=<?php echo e($i['id']); ?>" onclick="return confirm('Delete item?')">Delete</a>
    </td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
