<?php
require_once __DIR__ . '/../functions/auth.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../db/connection.php';
require_admin();
$restaurant_id = current_restaurant_id();
if (($_SESSION['role'] ?? '') === 'super' && get('restaurant_id')) $restaurant_id = (int)get('restaurant_id');
if (!$restaurant_id) die('Restaurant not selected.');

if (get('status') && get('id')) {
    $stmt = $pdo->prepare('UPDATE orders SET status=? WHERE id=? AND restaurant_id=?');
    $stmt->execute([get('status'), get('id'), $restaurant_id]);
    redirect('orders.php');
}

$orders = $pdo->prepare('SELECT * FROM orders WHERE restaurant_id=? ORDER BY id DESC');
$orders->execute([$restaurant_id]);
$orders = $orders->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Orders</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="categories.php">Categories</a>
    <a href="menu.php">Menu</a>
    <a href="finances.php">Finances</a>
    <a href="tables.php">Tables</a>
    <a href="logout.php">Logout</a>
</nav>
<h1>Orders</h1>

<table>
<tr><th>ID</th><th>User</th><th>Mode</th><th>Table</th><th>Status</th><th>Payment</th><th>Actions</th></tr>
<?php foreach ($orders as $o): ?>
<tr>
    <td><?php echo e($o['id']); ?></td>
    <td><?php echo e($o['user_id']); ?></td>
    <td><?php echo e($o['mode']); ?></td>
    <td><?php echo e($o['table_number']); ?></td>
    <td><?php echo e($o['status']); ?></td>
    <td><?php echo e($o['payment_method']); ?></td>
    <td>
        <a href="?id=<?php echo e($o['id']); ?>&status=ready">Mark Ready</a> |
        <a href="?id=<?php echo e($o['id']); ?>&status=completed">Mark Completed</a>
    </td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
