<?php
require_once __DIR__ . '/../functions/auth.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../db/connection.php';
require_admin();
$restaurant_id = current_restaurant_id();
if (($_SESSION['role'] ?? '') === 'super' && get('restaurant_id')) $restaurant_id = (int)get('restaurant_id');
if (!$restaurant_id) die('Restaurant not selected.');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && csrf_check(post('csrf'))) {
    $count = max(0, (int)post('table_count', 0));
    $pdo->prepare('UPDATE restaurants SET table_count=? WHERE id=?')->execute([$count, $restaurant_id]);
    redirect('tables.php');
}

$stmt = $pdo->prepare('SELECT table_count FROM restaurants WHERE id=?');
$stmt->execute([$restaurant_id]);
$table_count = $stmt->fetch()['table_count'] ?? 0;
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Tables</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="categories.php">Categories</a>
    <a href="menu.php">Menu</a>
    <a href="orders.php">Orders</a>
    <a href="finances.php">Finances</a>
    <a href="logout.php">Logout</a>
</nav>
<h1>Tables</h1>
<form method="post">
    <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>">
    <label>Table Count <input type="number" name="table_count" min="0" value="<?php echo e($table_count); ?>"></label>
    <button type="submit">Save</button>
</form>
<p>Users will manually enter their table number when placing a dine-in order.</p>
</body></html>
