-- TopPick initial schema

CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(190) UNIQUE NULL,
    password_hash VARCHAR(255) NOT NULL,
    created_at DATETIME NOT NULL
);

CREATE TABLE IF NOT EXISTS restaurants (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(190) NOT NULL,
    location VARCHAR(190) NULL,
    enable_dine_in TINYINT(1) NOT NULL DEFAULT 1,
    enable_pickup TINYINT(1) NOT NULL DEFAULT 1,
    enable_delivery TINYINT(1) NOT NULL DEFAULT 0,
    table_count INT NOT NULL DEFAULT 0,
    created_at DATETIME NOT NULL
);

CREATE TABLE IF NOT EXISTS admins (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(190) UNIQUE NOT NULL,
    password_hash VARCHAR(255) NOT NULL,
    role ENUM('super','restaurant') NOT NULL,
    restaurant_id INT NULL,
    created_at DATETIME NOT NULL,
    FOREIGN KEY (restaurant_id) REFERENCES restaurants(id) ON DELETE SET NULL
);

CREATE TABLE IF NOT EXISTS categories (
    id INT AUTO_INCREMENT PRIMARY KEY,
    restaurant_id INT NOT NULL,
    name_en VARCHAR(190) NOT NULL,
    name_ar VARCHAR(190) NULL,
    name_ku VARCHAR(190) NULL,
    created_at DATETIME NOT NULL,
    FOREIGN KEY (restaurant_id) REFERENCES restaurants(id) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS menu_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    restaurant_id INT NOT NULL,
    category_id INT NOT NULL,
    name_en VARCHAR(190) NOT NULL,
    name_ar VARCHAR(190) NULL,
    name_ku VARCHAR(190) NULL,
    desc_en TEXT NULL,
    desc_ar TEXT NULL,
    desc_ku TEXT NULL,
    price DECIMAL(10,2) NOT NULL,
    image_path VARCHAR(255) NULL,
    created_at DATETIME NOT NULL,
    FOREIGN KEY (restaurant_id) REFERENCES restaurants(id) ON DELETE CASCADE,
    FOREIGN KEY (category_id) REFERENCES categories(id) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS orders (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    restaurant_id INT NOT NULL,
    mode ENUM('dine-in','pickup','delivery') NOT NULL,
    table_number VARCHAR(50) NULL,
    status ENUM('pending','ready','completed') NOT NULL DEFAULT 'pending',
    payment_method ENUM('cash','bank_transfer') NOT NULL,
    created_at DATETIME NOT NULL,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE,
    FOREIGN KEY (restaurant_id) REFERENCES restaurants(id) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS order_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id INT NOT NULL,
    menu_item_id INT NOT NULL,
    quantity INT NOT NULL,
    price DECIMAL(10,2) NOT NULL,
    FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE,
    FOREIGN KEY (menu_item_id) REFERENCES menu_items(id) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    order_id INT NOT NULL,
    restaurant_id INT NOT NULL,
    gross_amount DECIMAL(10,2) NOT NULL,
    commission_amount DECIMAL(10,2) NOT NULL,
    net_amount DECIMAL(10,2) NOT NULL,
    status ENUM('paid','unpaid') NOT NULL DEFAULT 'unpaid',
    created_at DATETIME NOT NULL,
    paid_at DATETIME NULL,
    FOREIGN KEY (order_id) REFERENCES orders(id) ON DELETE CASCADE,
    FOREIGN KEY (restaurant_id) REFERENCES restaurants(id) ON DELETE CASCADE
);

CREATE TABLE IF NOT EXISTS finance_reports (
    id INT AUTO_INCREMENT PRIMARY KEY,
    restaurant_id INT NOT NULL,
    month DATE NOT NULL, -- YYYY-MM-01
    total_orders INT NOT NULL,
    gross_amount DECIMAL(10,2) NOT NULL,
    commission_amount DECIMAL(10,2) NOT NULL,
    net_amount DECIMAL(10,2) NOT NULL,
    generated_at DATETIME NOT NULL,
    UNIQUE KEY u_rest_month (restaurant_id, month),
    FOREIGN KEY (restaurant_id) REFERENCES restaurants(id) ON DELETE CASCADE
);

-- Seed a default Super Admin (email: admin@toppick.local / password: admin123)
INSERT INTO admins (email, password_hash, role, restaurant_id, created_at)
VALUES ('admin@toppick.local', '$2y$10$VY6c1l2u7sM2t3wZdz3s7e9Q9o4bQw9j5xv1U8K1H1pXbS6h5a8cO', 'super', NULL, NOW())
ON DUPLICATE KEY UPDATE email=email;
-- The above hash corresponds to 'admin123'
