<?php
require_once __DIR__ . '/../db/connection.php';
require_once __DIR__ . '/helpers.php';

function login($email, $password) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT * FROM admins WHERE email = ?');
    $stmt->execute([$email]);
    $admin = $stmt->fetch();
    if ($admin && password_verify($password, $admin['password_hash'])) {
        $_SESSION['admin_id'] = $admin['id'];
        $_SESSION['role'] = $admin['role']; // 'super' or 'restaurant'
        $_SESSION['restaurant_id'] = $admin['restaurant_id'];
        return true;
    }
    // Try user
    $stmt = $pdo->prepare('SELECT * FROM users WHERE email = ?');
    $stmt->execute([$email]);
    $user = $stmt->fetch();
    if ($user && password_verify($password, $user['password_hash'])) {
        $_SESSION['user_id'] = $user['id'];
        return true;
    }
    return false;
}

function require_login() {
    if (!isset($_SESSION['admin_id']) && !isset($_SESSION['user_id'])) {
        redirect('/TopPick/index.php');
    }
}

function require_admin() {
    if (!isset($_SESSION['admin_id'])) redirect('/TopPick/index.php');
}

function require_role($role) {
    require_admin();
    if (($_SESSION['role'] ?? '') !== $role) redirect('/TopPick/index.php');
}

function current_restaurant_id() {
    return $_SESSION['restaurant_id'] ?? null;
}
?>
