<?php
require_once __DIR__ . '/../db/connection.php';

function restaurant_finance_summary($restaurant_id) {
    global $pdo;
    $stmt = $pdo->prepare('SELECT 
        COUNT(*) as orders_count,
        COALESCE(SUM(p.gross_amount),0) as gross,
        COALESCE(SUM(p.commission_amount),0) as commission,
        COALESCE(SUM(p.net_amount),0) as net,
        SUM(p.status="paid") as paid_count,
        SUM(p.status="unpaid") as unpaid_count
        FROM payments p WHERE p.restaurant_id = ?');
    $stmt->execute([$restaurant_id]);
    return $stmt->fetch();
}

function mark_payment_paid($payment_id) {
    global $pdo;
    $pdo->prepare('UPDATE payments SET status = "paid", paid_at = NOW() WHERE id = ?')->execute([$payment_id]);
}
?>
