<?php
require_once __DIR__ . '/../db/connection.php';

function create_order($user_id, $restaurant_id, $mode, $table_number, $items, $payment_method) {
    // $items: array of ['menu_item_id'=>..., 'qty'=>...]
    global $pdo;
    $pdo->beginTransaction();
    try {
        $stmt = $pdo->prepare('INSERT INTO orders (user_id, restaurant_id, mode, table_number, status, payment_method, created_at) VALUES (?, ?, ?, ?, "pending", ?, NOW())');
        $stmt->execute([$user_id, $restaurant_id, $mode, $table_number, $payment_method]);
        $order_id = $pdo->lastInsertId();

        $total = 0;
        foreach ($items as $it) {
            $stmt = $pdo->prepare('SELECT price FROM menu_items WHERE id = ? AND restaurant_id = ?');
            $stmt->execute([$it["menu_item_id"], $restaurant_id]);
            $row = $stmt->fetch();
            if (!$row) continue;
            $price = (float)$row['price'];
            $qty = (int)$it['qty'];
            $line_total = $price * $qty;
            $total += $line_total;

            $pdo->prepare('INSERT INTO order_items (order_id, menu_item_id, quantity, price) VALUES (?, ?, ?, ?)')
                ->execute([$order_id, $it['menu_item_id'], $qty, $price]);
        }

        // Commission & payment record (unpaid by default)
        $commission = $total * PLATFORM_COMMISSION_RATE;
        $payout = $total - $commission;
        $pdo->prepare('INSERT INTO payments (order_id, restaurant_id, gross_amount, commission_amount, net_amount, status, created_at) VALUES (?, ?, ?, ?, ?, "unpaid", NOW())')
            ->execute([$order_id, $restaurant_id, $total, $commission, $payout]);

        $pdo->commit();
        return $order_id;
    } catch (Exception $e) {
        $pdo->rollBack();
        throw $e;
    }
}

function set_order_status($order_id, $status) {
    global $pdo;
    $pdo->prepare('UPDATE orders SET status = ? WHERE id = ?')->execute([$status, $order_id]);
}
?>
