<?php
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/functions/helpers.php';
require_once __DIR__ . '/functions/translations.php';
require_once __DIR__ . '/functions/auth.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (post('lang')) { $_SESSION['lang'] = post('lang'); }
    if (post('email') && post('password')) {
        if (login(post('email'), post('password'))) {
            if (isset($_SESSION['role'])) {
                if ($_SESSION['role'] === 'super') redirect('/TopPick/super-admin/index.php');
                else redirect('/TopPick/admin/index.php');
            } else {
                redirect('/TopPick/user/index.php');
            }
        } else {
            $error = 'Invalid credentials';
        }
    }
}

$lang = $_SESSION['lang'] ?? DEFAULT_LANG;
?>
<!doctype html>
<html>
<head>
    <meta charset="utf-8">
    <title><?php echo t('app_name'); ?> - <?php echo t('login'); ?></title>
    <link rel="stylesheet" href="/TopPick/assets/css/style.css">
</head>
<body>
    <h1><?php echo t('app_name'); ?></h1>

    <form method="post">
        <label><?php echo t('email'); ?><br>
            <input type="email" name="email" required>
        </label><br><br>
        <label><?php echo t('password'); ?><br>
            <input type="password" name="password" required>
        </label><br><br>
        <button type="submit"><?php echo t('login'); ?></button>
    </form>

    <?php if (!empty($error)) echo '<p style="color:red">'.e($error).'</p>'; ?>

    <form method="post" style="margin-top:20px">
        <select name="lang" onchange="this.form.submit()">
            <option value="en" <?php echo $lang==='en'?'selected':''; ?>>English</option>
            <option value="ar" <?php echo $lang==='ar'?'selected':''; ?>>العربية</option>
            <option value="ku" <?php echo $lang==='ku'?'selected':''; ?>>کوردی</option>
        </select>
        <noscript><button type="submit">Set</button></noscript>
    </form>

    <p><a href="/TopPick/user/index.php">Continue as guest</a></p>
</body>
</html>
