<?php
require_once __DIR__ . '/../functions/auth.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../db/connection.php';
require_admin(); require_role('super');

// Create/Update admin
if ($_SERVER['REQUEST_METHOD'] === 'POST' && csrf_check(post('csrf'))) {
    $id = post('id');
    $email = post('email');
    $restaurant_id = post('restaurant_id') ?: null;
    $role = post('role'); // super or restaurant
    $pass = post('password');
    if ($id) {
        $params = [$email, $role, $restaurant_id, $id];
        $sql = 'UPDATE admins SET email=?, role=?, restaurant_id=? WHERE id=?';
        if ($pass) {
            $sql = 'UPDATE admins SET email=?, role=?, restaurant_id=?, password_hash=? WHERE id=?';
            $params = [$email, $role, $restaurant_id, password_hash($pass, PASSWORD_BCRYPT), $id];
        }
        $pdo->prepare($sql)->execute($params);
    } else {
        $pdo->prepare('INSERT INTO admins (email, role, restaurant_id, password_hash, created_at) VALUES (?,?,?,?,NOW())')
            ->execute([$email, $role, $restaurant_id, password_hash($pass, PASSWORD_BCRYPT)]);
    }
    redirect('admins.php');
}

if (get('delete')) {
    $pdo->prepare('DELETE FROM admins WHERE id=?')->execute([get('delete')]);
    redirect('admins.php');
}

$restaurants = $pdo->query('SELECT id, name FROM restaurants ORDER BY name')->fetchAll();
$admins = $pdo->query('SELECT a.*, r.name as restaurant_name FROM admins a LEFT JOIN restaurants r ON a.restaurant_id=r.id ORDER BY a.id DESC')->fetchAll();

$edit = null;
if (get('edit')) {
    $stmt = $pdo->prepare('SELECT * FROM admins WHERE id=?');
    $stmt->execute([get('edit')]);
    $edit = $stmt->fetch();
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Admins</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="restaurants.php">Restaurants</a>
    <a href="finances.php">Finances</a>
    <a href="settings.php">Settings</a>
    <a href="logout.php">Logout</a>
</nav>
<h1>Admins</h1>

<h3><?php echo $edit ? 'Edit' : 'Create'; ?> Admin</h3>
<form method="post">
    <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>">
    <input type="hidden" name="id" value="<?php echo e($edit['id'] ?? ''); ?>">
    <div class="form-row"><label>Email <input type="email" name="email" required value="<?php echo e($edit['email'] ?? ''); ?>"></label></div>
    <div class="form-row"><label>Role 
        <select name="role">
            <option value="super" <?php echo (($edit['role'] ?? '')==='super')?'selected':''; ?>>Super Admin</option>
            <option value="restaurant" <?php echo (($edit['role'] ?? '')==='restaurant')?'selected':''; ?>>Restaurant Admin</option>
        </select>
    </label></div>
    <div class="form-row"><label>Restaurant (for Restaurant Admin)
        <select name="restaurant_id">
            <option value="">-- none --</option>
            <?php foreach ($restaurants as $r): ?>
                <option value="<?php echo e($r['id']); ?>" <?php echo (($edit['restaurant_id'] ?? '')==$r['id'])?'selected':''; ?>><?php echo e($r['name']); ?></option>
            <?php endforeach; ?>
        </select>
    </label></div>
    <div class="form-row"><label>Password <input type="password" name="password" <?php echo $edit?'':'required'; ?>></label></div>
    <button type="submit">Save</button>
</form>

<h3>All Admins</h3>
<table>
<tr><th>ID</th><th>Email</th><th>Role</th><th>Restaurant</th><th>Actions</th></tr>
<?php foreach ($admins as $a): ?>
<tr>
    <td><?php echo e($a['id']); ?></td>
    <td><?php echo e($a['email']); ?></td>
    <td><?php echo e($a['role']); ?></td>
    <td><?php echo e($a['restaurant_name'] ?? '-'); ?></td>
    <td>
        <a href="?edit=<?php echo e($a['id']); ?>">Edit</a> |
        <a href="?delete=<?php echo e($a['id']); ?>" onclick="return confirm('Delete admin?')">Delete</a>
    </td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
