<?php
require_once __DIR__ . '/../functions/auth.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../db/connection.php';
require_admin(); require_role('super');

$rows = $pdo->query('SELECT r.name,
    COUNT(p.id) as orders_count,
    COALESCE(SUM(p.gross_amount),0) as gross,
    COALESCE(SUM(p.commission_amount),0) as commission,
    COALESCE(SUM(p.net_amount),0) as net,
    SUM(p.status="paid") as paid_count,
    SUM(p.status="unpaid") as unpaid_count
    FROM restaurants r LEFT JOIN payments p ON p.restaurant_id=r.id GROUP BY r.id ORDER BY r.name')->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Finances</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="restaurants.php">Restaurants</a>
    <a href="admins.php">Admins</a>
    <a href="settings.php">Settings</a>
    <a href="logout.php">Logout</a>
</nav>
<h1>Finance Overview</h1>
<table>
<tr><th>Restaurant</th><th>Orders</th><th>Gross</th><th>Commission</th><th>Net</th><th>Paid</th><th>Unpaid</th></tr>
<?php foreach ($rows as $row): ?>
<tr>
    <td><?php echo e($row['name']); ?></td>
    <td><?php echo e($row['orders_count']); ?></td>
    <td><?php echo number_format($row['gross'],2); ?></td>
    <td><?php echo number_format($row['commission'],2); ?></td>
    <td><?php echo number_format($row['net'],2); ?></td>
    <td><?php echo e($row['paid_count']); ?></td>
    <td><?php echo e($row['unpaid_count']); ?></td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
