<?php
require_once __DIR__ . '/../functions/auth.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../db/connection.php';
require_admin(); require_role('super');

// Create/Update
if ($_SERVER['REQUEST_METHOD'] === 'POST' && csrf_check(post('csrf'))) {
    $id = post('id');
    $name = post('name');
    $location = post('location');
    $enable_dine_in = post('enable_dine_in') ? 1 : 0;
    $enable_pickup = post('enable_pickup') ? 1 : 0;
    $enable_delivery = post('enable_delivery') ? 1 : 0;
    $table_count = max(0, (int)post('table_count', 0));
    if ($id) {
        $stmt = $pdo->prepare('UPDATE restaurants SET name=?, location=?, enable_dine_in=?, enable_pickup=?, enable_delivery=?, table_count=? WHERE id=?');
        $stmt->execute([$name, $location, $enable_dine_in, $enable_pickup, $enable_delivery, $table_count, $id]);
    } else {
        $stmt = $pdo->prepare('INSERT INTO restaurants (name, location, enable_dine_in, enable_pickup, enable_delivery, table_count, created_at) VALUES (?,?,?,?,?,?,NOW())');
        $stmt->execute([$name, $location, $enable_dine_in, $enable_pickup, $enable_delivery, $table_count]);
    }
    redirect('restaurants.php');
}

// Delete
if (get('delete')) {
    $stmt = $pdo->prepare('DELETE FROM restaurants WHERE id=?');
    $stmt->execute([get('delete')]);
    redirect('restaurants.php');
}

$restaurants = $pdo->query('SELECT * FROM restaurants ORDER BY id DESC')->fetchAll();
$edit = null;
if (get('edit')) {
    $stmt = $pdo->prepare('SELECT * FROM restaurants WHERE id=?');
    $stmt->execute([get('edit')]);
    $edit = $stmt->fetch();
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Restaurants</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Dashboard</a>
    <a href="admins.php">Admins</a>
    <a href="finances.php">Finances</a>
    <a href="settings.php">Settings</a>
    <a href="logout.php">Logout</a>
</nav>
<h1>Restaurants</h1>

<h3><?php echo $edit ? 'Edit' : 'Create'; ?> Restaurant</h3>
<form method="post">
    <input type="hidden" name="csrf" value="<?php echo csrf_token(); ?>">
    <input type="hidden" name="id" value="<?php echo e($edit['id'] ?? ''); ?>">
    <div class="form-row">
        <label>Name <input type="text" name="name" value="<?php echo e($edit['name'] ?? ''); ?>" required></label>
    </div>
    <div class="form-row">
        <label>Location <input type="text" name="location" value="<?php echo e($edit['location'] ?? ''); ?>"></label>
    </div>
    <div class="form-row">
        <label><input type="checkbox" name="enable_dine_in" <?php echo !empty($edit['enable_dine_in'])?'checked':''; ?>> Dine-in</label>
        <label><input type="checkbox" name="enable_pickup" <?php echo !empty($edit['enable_pickup'])?'checked':''; ?>> Pickup</label>
        <label><input type="checkbox" name="enable_delivery" <?php echo !empty($edit['enable_delivery'])?'checked':''; ?>> Delivery</label>
    </div>
    <div class="form-row">
        <label>Table Count <input type="number" min="0" name="table_count" value="<?php echo e($edit['table_count'] ?? 0); ?>"></label>
    </div>
    <button type="submit">Save</button>
</form>

<h3>All Restaurants</h3>
<table>
    <tr><th>ID</th><th>Name</th><th>Location</th><th>Modes</th><th>Tables</th><th>Actions</th></tr>
    <?php foreach ($restaurants as $r): ?>
        <tr>
            <td><?php echo e($r['id']); ?></td>
            <td><?php echo e($r['name']); ?></td>
            <td><?php echo e($r['location']); ?></td>
            <td>
                <?php echo $r['enable_dine_in']?'Dine-in ':'- '; ?>
                <?php echo $r['enable_pickup']?'Pickup ':'- '; ?>
                <?php echo $r['enable_delivery']?'Delivery':'-'; ?>
            </td>
            <td><?php echo e($r['table_count']); ?></td>
            <td>
                <a href="?edit=<?php echo e($r['id']); ?>">Edit</a> |
                <a href="?delete=<?php echo e($r['id']); ?>" onclick="return confirm('Delete restaurant?')">Delete</a>
            </td>
        </tr>
    <?php endforeach; ?>
</table>
</body></html>
