<?php
require_once __DIR__ . '/../db/connection.php';
require_once __DIR__ . '/../functions/helpers.php';
require_once __DIR__ . '/../functions/orders.php';

$restaurant_id = (int)post('restaurant_id');
$mode = post('mode');
$table_number = post('table_number');
$items = $_POST['items'] ?? [];
$payment_method = 'cash'; // default

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm'])) {
    $payment_method = post('payment_method', 'cash');
    $user_id = $_SESSION['user_id'] ?? null;
    if (!$user_id) {
        // auto-create guest user
        $pdo->prepare('INSERT INTO users (email, password_hash, created_at) VALUES (?, ?, NOW())')
            ->execute([NULL, password_hash(bin2hex(random_bytes(6)), PASSWORD_BCRYPT)]);
        $user_id = $pdo->lastInsertId();
        $_SESSION['user_id'] = $user_id;
    }
    $order_id = create_order($user_id, $restaurant_id, $mode, $table_number, $items, $payment_method);
    header('Location: my-orders.php?placed=' . $order_id);
    exit;
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Checkout</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Restaurants</a>
    <a href="my-orders.php">My Orders</a>
</nav>
<h1>Checkout</h1>
<form method="post">
    <input type="hidden" name="restaurant_id" value="<?php echo e($restaurant_id); ?>">
    <?php foreach ($items as $idx=>$it): ?>
        <input type="hidden" name="items[<?php echo $idx; ?>][menu_item_id]" value="<?php echo e($it['menu_item_id']); ?>">
        <input type="hidden" name="items[<?php echo $idx; ?>][qty]" value="<?php echo e($it['qty']); ?>">
    <?php endforeach; ?>
    <input type="hidden" name="mode" value="<?php echo e($mode); ?>">
    <input type="hidden" name="table_number" value="<?php echo e($table_number); ?>">

    <div class="form-row">
        <label>Payment Method
            <select name="payment_method">
                <option value="cash">Cash</option>
                <option value="bank_transfer">Bank Transfer</option>
            </select>
        </label>
    </div>
    <button type="submit" name="confirm" value="1">Place Order</button>
</form>
</body></html>
