<?php
require_once __DIR__ . '/../db/connection.php';
require_once __DIR__ . '/../functions/helpers.php';

$restaurants = $pdo->query('SELECT * FROM restaurants ORDER BY name')->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>TopPick - Restaurants</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="/TopPick/index.php">Login</a>
    <a href="my-orders.php">My Orders</a>
</nav>
<h1>Restaurants</h1>
<table>
<tr><th>Name</th><th>Location</th><th>Modes</th><th></th></tr>
<?php foreach ($restaurants as $r): ?>
<tr>
    <td><?php echo e($r['name']); ?></td>
    <td><?php echo e($r['location']); ?></td>
    <td>
        <?php echo $r['enable_dine_in']?'Dine-in ':'- '; ?>
        <?php echo $r['enable_pickup']?'Pickup ':'- '; ?>
        <?php echo $r['enable_delivery']?'Delivery':'-'; ?>
    </td>
    <td><a href="restaurant.php?id=<?php echo e($r['id']); ?>">View</a></td>
</tr>
<?php endforeach; ?>
</table>
</body></html>
