<?php
require_once __DIR__ . '/../db/connection.php';
require_once __DIR__ . '/../functions/helpers.php';

$user_id = $_SESSION['user_id'] ?? 0;
$orders = [];
if ($user_id) {
    $stmt = $pdo->prepare('SELECT o.*, r.name as restaurant_name FROM orders o JOIN restaurants r ON o.restaurant_id=r.id WHERE o.user_id=? ORDER BY o.id DESC');
    $stmt->execute([$user_id]);
    $orders = $stmt->fetchAll();
}
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>My Orders</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Restaurants</a>
    <a href="/TopPick/index.php">Login</a>
</nav>
<h1>My Orders</h1>
<?php if (get('placed')): ?><p style="color:green">Order #<?php echo e(get('placed')); ?> placed!</p><?php endif; ?>
<?php if (!$user_id): ?>
    <p>No user session yet. Place an order to create a guest account automatically.</p>
<?php else: ?>
<table>
<tr><th>ID</th><th>Restaurant</th><th>Mode</th><th>Table</th><th>Status</th><th>Payment</th></tr>
<?php foreach ($orders as $o): ?>
<tr>
    <td><?php echo e($o['id']); ?></td>
    <td><?php echo e($o['restaurant_name']); ?></td>
    <td><?php echo e($o['mode']); ?></td>
    <td><?php echo e($o['table_number']); ?></td>
    <td><?php echo e($o['status']); ?></td>
    <td><?php echo e($o['payment_method']); ?></td>
</tr>
<?php endforeach; ?>
</table>
<?php endif; ?>
</body></html>
