<?php
require_once __DIR__ . '/../db/connection.php';
require_once __DIR__ . '/../functions/helpers.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') redirect('index.php');

$restaurant_id = (int)post('restaurant_id');
$quantities = $_POST['qty'] ?? [];
$items = [];
foreach ($quantities as $item_id => $qty) {
    $qty = (int)$qty;
    if ($qty > 0) $items[] = ['menu_item_id' => (int)$item_id, 'qty' => $qty];
}
if (empty($items)) redirect('restaurant.php?id='.$restaurant_id);

$stmt = $pdo->prepare('SELECT * FROM restaurants WHERE id=?');
$stmt->execute([$restaurant_id]);
$restaurant = $stmt->fetch();
if (!$restaurant) die('Restaurant not found');
?>
<!doctype html>
<html><head><meta charset="utf-8"><title>Order - <?php echo e($restaurant['name']); ?></title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="restaurant.php?id=<?php echo e($restaurant_id); ?>">Back to Menu</a>
    <a href="my-orders.php">My Orders</a>
</nav>
<h1>Confirm Order</h1>
<form method="post" action="checkout.php">
    <input type="hidden" name="restaurant_id" value="<?php echo e($restaurant_id); ?>">
    <?php foreach ($items as $idx=>$it): ?>
        <input type="hidden" name="items[<?php echo $idx; ?>][menu_item_id]" value="<?php echo e($it['menu_item_id']); ?>">
        <input type="hidden" name="items[<?php echo $idx; ?>][qty]" value="<?php echo e($it['qty']); ?>">
    <?php endforeach; ?>

    <div class="form-row">
        <label>Order Mode
            <select name="mode" required>
                <?php if ($restaurant['enable_dine_in']): ?><option value="dine-in">Dine-in</option><?php endif; ?>
                <?php if ($restaurant['enable_pickup']): ?><option value="pickup">Pickup</option><?php endif; ?>
                <?php if ($restaurant['enable_delivery']): ?><option value="delivery">Delivery</option><?php endif; ?>
            </select>
        </label>
    </div>
    <div class="form-row">
        <label>Table Number (for Dine-in) <input type="text" name="table_number" placeholder="e.g., 12"></label>
    </div>
    <button type="submit">Proceed to Checkout</button>
</form>
</body></html>
