<?php
require_once __DIR__ . '/../db/connection.php';
require_once __DIR__ . '/../functions/helpers.php';

$restaurant_id = (int)get('id', 0);
$stmt = $pdo->prepare('SELECT * FROM restaurants WHERE id=?');
$stmt->execute([$restaurant_id]);
$restaurant = $stmt->fetch();
if (!$restaurant) die('Restaurant not found');

$cats = $pdo->prepare('SELECT * FROM categories WHERE restaurant_id=? ORDER BY name_en');
$cats->execute([$restaurant_id]);
$cats = $cats->fetchAll();

$items = $pdo->prepare('SELECT * FROM menu_items WHERE restaurant_id=? ORDER BY category_id, name_en');
$items->execute([$restaurant_id]);
$items = $items->fetchAll();
?>
<!doctype html>
<html><head><meta charset="utf-8"><title><?php echo e($restaurant['name']); ?> - Menu</title>
<link rel="stylesheet" href="/TopPick/assets/css/style.css"></head>
<body>
<nav>
    <a href="index.php">Restaurants</a>
    <a href="my-orders.php">My Orders</a>
</nav>
<h1><?php echo e($restaurant['name']); ?></h1>
<p><?php echo e($restaurant['location']); ?></p>

<form method="post" action="order.php">
    <input type="hidden" name="restaurant_id" value="<?php echo e($restaurant_id); ?>">
    <table>
        <tr><th>Item</th><th>Description</th><th>Price</th><th>Qty</th></tr>
        <?php foreach ($items as $i): ?>
        <tr>
            <td><?php echo e($i['name_en']); ?></td>
            <td><?php echo e($i['desc_en']); ?></td>
            <td><?php echo number_format($i['price'],2); ?></td>
            <td><input type="number" min="0" name="qty[<?php echo e($i['id']); ?>]" value="0" style="width:70px"></td>
        </tr>
        <?php endforeach; ?>
    </table>
    <button type="submit">Add to Order</button>
</form>
</body></html>
