<?php
session_start();
require_once '../config/database.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

if (!isLoggedIn() || !hasRole(ROLE_RESTAURANT_ADMIN)) {
    redirect('../admin/login.php');
}

$restaurant_id = getCurrentRestaurantId();

// Handle status update
if (isset($_POST['update_status'])) {
    $order_id = clean($_POST['order_id']);
    $status = clean($_POST['status']);
    
    $stmt = $db->prepare("UPDATE orders SET status = ? WHERE id = ?");
    if ($stmt->execute([$status, $order_id])) {
        logOrderStatus($order_id, $status, $db);
        $_SESSION['message'] = 'Order status updated!';
    } else {
        $_SESSION['error'] = 'Error updating order status';
    }
    redirect('orders.php');
}

// Get active sessions with orders
$stmt = $db->prepare("SELECT s.*, t.table_number 
                     FROM sessions s 
                     JOIN tables t ON s.table_id = t.id 
                     WHERE t.restaurant_id = ? AND s.status = 'open' 
                     ORDER BY s.start_time DESC");
$stmt->execute([$restaurant_id]);
$sessions = $stmt->fetchAll();

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <?php include 'sidebar.php'; ?>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Orders Management</h1>
            </div>

            <?php if (empty($sessions)): ?>
                <div class="alert alert-info">No active sessions with orders.</div>
            <?php endif; ?>

            <div class="row">
                <?php foreach ($sessions as $session): ?>
                    <div class="col-md-6 mb-4">
                        <div class="card">
                            <div class="card-header bg-primary text-white">
                                <h5 class="mb-0">Table <?php echo $session['table_number']; ?></h5>
                                <small>Session started: <?php echo date('H:i', strtotime($session['start_time'])); ?></small>
                            </div>
                            <div class="card-body">
                                <?php
                                $orders_stmt = $db->prepare("SELECT o.*, mi.name_en as item_name, mi.price 
                                                           FROM orders o 
                                                           JOIN menu_items mi ON o.item_id = mi.id 
                                                           WHERE o.session_id = ? 
                                                           ORDER BY o.status, o.created_at");
                                $orders_stmt->execute([$session['id']]);
                                $orders = $orders_stmt->fetchAll();
                                
                                if ($orders): ?>
                                    <div class="table-responsive">
                                        <table class="table table-sm">
                                            <thead>
                                                <tr>
                                                    <th>Item</th>
                                                    <th>Qty</th>
                                                    <th>Status</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($orders as $order): ?>
                                                    <tr>
                                                        <td>
                                                            <strong><?php echo $order['item_name']; ?></strong>
                                                            <?php if ($order['note']): ?>
                                                                <br><small class="text-muted">Note: <?php echo $order['note']; ?></small>
                                                            <?php endif; ?>
                                                        </td>
                                                        <td><?php echo $order['quantity']; ?></td>
                                                        <td>
                                                            <span class="badge bg-<?php 
                                                                switch($order['status']) {
                                                                    case 'pending': echo 'warning'; break;
                                                                    case 'preparing': echo 'info'; break;
                                                                    case 'ready': echo 'success'; break;
                                                                    case 'delivered': echo 'secondary'; break;
                                                                    default: echo 'light';
                                                                }
                                                            ?>"><?php echo ucfirst($order['status']); ?></span>
                                                        </td>
                                                        <td>
                                                            <form method="POST" class="d-inline">
                                                                <input type="hidden" name="order_id" value="<?php echo $order['id']; ?>">
                                                                <select name="status" class="form-select form-select-sm" onchange="this.form.submit()">
                                                                    <option value="pending" <?php echo $order['status'] == 'pending' ? 'selected' : ''; ?>>Pending</option>
                                                                    <option value="preparing" <?php echo $order['status'] == 'preparing' ? 'selected' : ''; ?>>Preparing</option>
                                                                    <option value="ready" <?php echo $order['status'] == 'ready' ? 'selected' : ''; ?>>Ready</option>
                                                                    <option value="delivered" <?php echo $order['status'] == 'delivered' ? 'selected' : ''; ?>>Delivered</option>
                                                                </select>
                                                                <input type="hidden" name="update_status" value="1">
                                                            </form>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <?php
                                    $total_stmt = $db->prepare("SELECT SUM(total_price) as total FROM orders WHERE session_id = ?");
                                    $total_stmt->execute([$session['id']]);
                                    $total = $total_stmt->fetch();
                                    ?>
                                    <div class="d-flex justify-content-between align-items-center mt-3">
                                        <strong>Total: <?php echo formatCurrency($total['total'] ?? 0); ?></strong>
                                        <form method="POST" action="../api/close_session.php">
                                            <input type="hidden" name="session_id" value="<?php echo $session['id']; ?>">
                                            <button type="submit" class="btn btn-sm btn-danger" 
                                                    onclick="return confirm('Close this session?')">Close Session</button>
                                        </form>
                                    </div>
                                <?php else: ?>
                                    <p class="text-muted">No orders for this session.</p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </main>
    </div>
</div>

<?php include '../includes/footer.php'; ?>