<?php
class Database {
    private $host = "localhost";
    private $db_name = "qr_ordering_system";
    private $username = "root";
    private $password = "";
    public $conn;

    public function getConnection() {
        $this->conn = null;
        try {
            $this->conn = new PDO("mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4", $this->username, $this->password);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->conn->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            
            // Test connection by checking if restaurants table exists
            $test = $this->conn->query("SELECT 1 FROM restaurants LIMIT 1");
            
        } catch(PDOException $exception) {
            // If database doesn't exist, create it
            if ($exception->getCode() == 1049) {
                $this->createDatabase();
            } else {
                echo "Connection error: " . $exception->getMessage();
            }
        }
        return $this->conn;
    }

    private function createDatabase() {
        try {
            $temp_conn = new PDO("mysql:host=" . $this->host, $this->username, $this->password);
            $temp_conn->exec("CREATE DATABASE IF NOT EXISTS " . $this->db_name . " CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            
            // Reconnect to the new database
            $this->conn = new PDO("mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=utf8mb4", $this->username, $this->password);
            $this->conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            
            echo "Database created successfully. Please run install.php to set up tables.<br>";
            
        } catch(PDOException $e) {
            die("Error creating database: " . $e->getMessage());
        }
    }
}

// Create database instance
$database = new Database();
$db = $database->getConnection();
?>