<?php
require_once 'config/constants.php';

// ... (previous functions remain the same)

// Database helper functions
function getRestaurantById($id, $db) {
    $stmt = $db->prepare("SELECT * FROM restaurants WHERE id = ?");
    $stmt->execute([$id]);
    return $stmt->fetch();
}

function getTableByToken($token, $db) {
    $stmt = $db->prepare("SELECT t.*, r.name as restaurant_name FROM tables t 
                         JOIN restaurants r ON t.restaurant_id = r.id 
                         WHERE t.qr_token = ? AND t.status = 'active'");
    $stmt->execute([$token]);
    return $stmt->fetch();
}

function getMenuCategories($restaurant_id, $db) {
    $stmt = $db->prepare("SELECT * FROM menu_categories 
                         WHERE restaurant_id = ? AND status = 'active' 
                         ORDER BY display_order");
    $stmt->execute([$restaurant_id]);
    return $stmt->fetchAll();
}

function getMenuItemsByCategory($category_id, $db) {
    $stmt = $db->prepare("SELECT * FROM menu_items 
                         WHERE category_id = ? AND is_available = 1 
                         ORDER BY display_order");
    $stmt->execute([$category_id]);
    return $stmt->fetchAll();
}

function getCurrentSession($table_id, $db) {
    $stmt = $db->prepare("SELECT * FROM sessions 
                         WHERE table_id = ? AND status = 'open' 
                         ORDER BY start_time DESC LIMIT 1");
    $stmt->execute([$table_id]);
    return $stmt->fetch();
}

function createNewSession($table_id, $db) {
    $session_token = generateToken(32);
    $stmt = $db->prepare("INSERT INTO sessions (table_id, session_token, status, start_time) 
                         VALUES (?, ?, 'open', NOW())");
    $stmt->execute([$table_id, $session_token]);
    return $db->lastInsertId();
}

function addOrderToSession($session_id, $item_id, $quantity, $note, $unit_price, $db) {
    $total_price = $unit_price * $quantity;
    $stmt = $db->prepare("INSERT INTO orders (session_id, item_id, quantity, note, unit_price, total_price, status) 
                         VALUES (?, ?, ?, ?, ?, ?, 'pending')");
    $stmt->execute([$session_id, $item_id, $quantity, $note, $unit_price, $total_price]);
    
    $order_id = $db->lastInsertId();
    
    // Log status change
    logOrderStatus($order_id, 'pending', $db);
    
    return $order_id;
}
?>