<?php
session_start();
require_once '../config/database.php';
require_once '../includes/functions.php';
require_once '../includes/auth.php';

if (!isLoggedIn() || !hasRole(ROLE_SUPER_ADMIN)) {
    redirect('login.php');
}

// Handle form actions
if ($_POST) {
    if (isset($_POST['add_admin'])) {
        $username = clean($_POST['username']);
        $password = clean($_POST['password']);
        $email = clean($_POST['email']);
        $full_name = clean($_POST['full_name']);
        $restaurant_id = clean($_POST['restaurant_id']);
        
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        
        $stmt = $db->prepare("INSERT INTO restaurant_admins (username, password, email, full_name, restaurant_id) 
                             VALUES (?, ?, ?, ?, ?)");
        if ($stmt->execute([$username, $hashed_password, $email, $full_name, $restaurant_id])) {
            $_SESSION['message'] = 'Restaurant admin added successfully!';
        } else {
            $_SESSION['error'] = 'Error adding restaurant admin';
        }
    }
    
    if (isset($_POST['update_admin'])) {
        $admin_id = clean($_POST['admin_id']);
        $email = clean($_POST['email']);
        $full_name = clean($_POST['full_name']);
        $restaurant_id = clean($_POST['restaurant_id']);
        $status = clean($_POST['status']);
        
        $stmt = $db->prepare("UPDATE restaurant_admins SET email = ?, full_name = ?, restaurant_id = ?, status = ? 
                             WHERE id = ?");
        if ($stmt->execute([$email, $full_name, $restaurant_id, $status, $admin_id])) {
            $_SESSION['message'] = 'Restaurant admin updated successfully!';
        } else {
            $_SESSION['error'] = 'Error updating restaurant admin';
        }
    }
    
    if (isset($_POST['reset_password'])) {
        $admin_id = clean($_POST['admin_id']);
        $new_password = clean($_POST['new_password']);
        
        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
        
        $stmt = $db->prepare("UPDATE restaurant_admins SET password = ? WHERE id = ?");
        if ($stmt->execute([$hashed_password, $admin_id])) {
            $_SESSION['message'] = 'Password reset successfully!';
        } else {
            $_SESSION['error'] = 'Error resetting password';
        }
    }
    
    redirect('admins.php');
}

// Get all restaurants for dropdown
$restaurants_stmt = $db->query("SELECT * FROM restaurants ORDER BY name");
$restaurants = $restaurants_stmt->fetchAll();

// Get all admins
$admins_stmt = $db->query("SELECT ra.*, r.name as restaurant_name 
                          FROM restaurant_admins ra 
                          JOIN restaurants r ON ra.restaurant_id = r.id 
                          ORDER BY ra.created_at DESC");
$admins = $admins_stmt->fetchAll();

// Filter by restaurant if specified
$filter_restaurant_id = isset($_GET['restaurant_id']) ? intval($_GET['restaurant_id']) : null;
if ($filter_restaurant_id) {
    $admins_stmt = $db->prepare("SELECT ra.*, r.name as restaurant_name 
                                FROM restaurant_admins ra 
                                JOIN restaurants r ON ra.restaurant_id = r.id 
                                WHERE ra.restaurant_id = ? 
                                ORDER BY ra.created_at DESC");
    $admins_stmt->execute([$filter_restaurant_id]);
    $admins = $admins_stmt->fetchAll();
}

include '../includes/header.php';
?>

<div class="container-fluid">
    <div class="row">
        <nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-light sidebar">
            <div class="position-sticky pt-3">
                <div class="sidebar-header p-3 border-bottom">
                    <h5>Super Admin Panel</h5>
                    <p class="text-muted mb-0 small"><?php echo $_SESSION['full_name']; ?></p>
                </div>
                <ul class="nav flex-column">
                    <li class="nav-item">
                        <a class="nav-link" href="dashboard.php">
                            <i class="fas fa-tachometer-alt"></i>
                            Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="restaurants.php">
                            <i class="fas fa-store"></i>
                            Restaurants
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="admins.php">
                            <i class="fas fa-users"></i>
                            Restaurant Admins
                        </a>
                    </li>
                    <li class="nav-item mt-3">
                        <a class="nav-link text-danger" href="../includes/logout.php">
                            <i class="fas fa-sign-out-alt"></i>
                            Logout
                        </a>
                    </li>
                </ul>
            </div>
        </nav>
        
        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Restaurant Admins Management</h1>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addAdminModal">
                    Add New Admin
                </button>
            </div>

            <!-- Restaurant Filter -->
            <div class="row mb-4">
                <div class="col-md-6">
                    <form method="GET" class="d-flex">
                        <select name="restaurant_id" class="form-select me-2" onchange="this.form.submit()">
                            <option value="">All Restaurants</option>
                            <?php foreach ($restaurants as $restaurant): ?>
                                <option value="<?php echo $restaurant['id']; ?>" 
                                        <?php echo $filter_restaurant_id == $restaurant['id'] ? 'selected' : ''; ?>>
                                    <?php echo $restaurant['name']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <?php if ($filter_restaurant_id): ?>
                            <a href="admins.php" class="btn btn-outline-secondary">Clear Filter</a>
                        <?php endif; ?>
                    </form>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Username</th>
                            <th>Full Name</th>
                            <th>Email</th>
                            <th>Restaurant</th>
                            <th>Status</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($admins as $admin): ?>
                            <tr>
                                <td><?php echo $admin['username']; ?></td>
                                <td><?php echo $admin['full_name']; ?></td>
                                <td><?php echo $admin['email']; ?></td>
                                <td><?php echo $admin['restaurant_name']; ?></td>
                                <td>
                                    <span class="badge bg-<?php echo $admin['status'] == 'active' ? 'success' : 'secondary'; ?>">
                                        <?php echo ucfirst($admin['status']); ?>
                                    </span>
                                </td>
                                <td><?php echo date('M j, Y', strtotime($admin['created_at'])); ?></td>
                                <td>
                                    <button type="button" class="btn btn-sm btn-outline-primary" 
                                            data-bs-toggle="modal" data-bs-target="#editAdminModal<?php echo $admin['id']; ?>">
                                        Edit
                                    </button>
                                    <button type="button" class="btn btn-sm btn-outline-warning" 
                                            data-bs-toggle="modal" data-bs-target="#resetPasswordModal<?php echo $admin['id']; ?>">
                                        Reset Password
                                    </button>
                                </td>
                            </tr>
                            
                            <!-- Edit Admin Modal -->
                            <div class="modal fade" id="editAdminModal<?php echo $admin['id']; ?>" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Edit Restaurant Admin</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <form method="POST">
                                            <div class="modal-body">
                                                <input type="hidden" name="admin_id" value="<?php echo $admin['id']; ?>">
                                                
                                                <div class="mb-3">
                                                    <label class="form-label">Username</label>
                                                    <input type="text" class="form-control" value="<?php echo $admin['username']; ?>" readonly>
                                                    <small class="text-muted">Username cannot be changed</small>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="full_name" class="form-label">Full Name</label>
                                                    <input type="text" class="form-control" id="full_name" name="full_name" 
                                                           value="<?php echo $admin['full_name']; ?>" required>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="email" class="form-label">Email</label>
                                                    <input type="email" class="form-control" id="email" name="email" 
                                                           value="<?php echo $admin['email']; ?>">
                                                </div>
                                                <div class="mb-3">
                                                    <label for="restaurant_id" class="form-label">Restaurant</label>
                                                    <select class="form-control" id="restaurant_id" name="restaurant_id" required>
                                                        <?php foreach ($restaurants as $restaurant): ?>
                                                            <option value="<?php echo $restaurant['id']; ?>" 
                                                                    <?php echo $restaurant['id'] == $admin['restaurant_id'] ? 'selected' : ''; ?>>
                                                                <?php echo $restaurant['name']; ?>
                                                            </option>
                                                        <?php endforeach; ?>
                                                    </select>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="status" class="form-label">Status</label>
                                                    <select class="form-control" id="status" name="status" required>
                                                        <option value="active" <?php echo $admin['status'] == 'active' ? 'selected' : ''; ?>>Active</option>
                                                        <option value="inactive" <?php echo $admin['status'] == 'inactive' ? 'selected' : ''; ?>>Inactive</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" name="update_admin" class="btn btn-primary">Update Admin</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Reset Password Modal -->
                            <div class="modal fade" id="resetPasswordModal<?php echo $admin['id']; ?>" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Reset Password for <?php echo $admin['username']; ?></h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <form method="POST">
                                            <div class="modal-body">
                                                <input type="hidden" name="admin_id" value="<?php echo $admin['id']; ?>">
                                                
                                                <div class="mb-3">
                                                    <label for="new_password" class="form-label">New Password</label>
                                                    <input type="password" class="form-control" id="new_password" name="new_password" 
                                                           minlength="6" required>
                                                    <small class="text-muted">Minimum 6 characters</small>
                                                </div>
                                                <div class="mb-3">
                                                    <label for="confirm_password" class="form-label">Confirm Password</label>
                                                    <input type="password" class="form-control" id="confirm_password" 
                                                           oninput="checkPasswordMatch(this)" required>
                                                    <small id="passwordMatch" class="form-text"></small>
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                                                <button type="submit" name="reset_password" class="btn btn-warning" id="resetPasswordBtn" disabled>
                                                    Reset Password
                                                </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </main>
    </div>
</div>

<!-- Add Admin Modal -->
<div class="modal fade" id="addAdminModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Add New Restaurant Admin</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="username" class="form-label">Username</label>
                        <input type="text" class="form-control" id="username" name="username" required>
                    </div>
                    <div class="mb-3">
                        <label for="password" class="form-label">Password</label>
                        <input type="password" class="form-control" id="password" name="password" minlength="6" required>
                        <small class="text-muted">Minimum 6 characters</small>
                    </div>
                    <div class="mb-3">
                        <label for="full_name" class="form-label">Full Name</label>
                        <input type="text" class="form-control" id="full_name" name="full_name" required>
                    </div>
                    <div class="mb-3">
                        <label for="email" class="form-label">Email</label>
                        <input type="email" class="form-control" id="email" name="email">
                    </div>
                    <div class="mb-3">
                        <label for="restaurant_id" class="form-label">Restaurant</label>
                        <select class="form-control" id="restaurant_id" name="restaurant_id" required>
                            <?php foreach ($restaurants as $restaurant): ?>
                                <option value="<?php echo $restaurant['id']; ?>"><?php echo $restaurant['name']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" name="add_admin" class="btn btn-primary">Add Admin</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function checkPasswordMatch(confirmField) {
    const password = document.getElementById('new_password').value;
    const confirmPassword = confirmField.value;
    const matchText = document.getElementById('passwordMatch');
    const submitBtn = document.getElementById('resetPasswordBtn');
    
    if (confirmPassword === '') {
        matchText.textContent = '';
        matchText.className = 'form-text';
        submitBtn.disabled = true;
    } else if (password === confirmPassword) {
        matchText.textContent = 'Passwords match!';
        matchText.className = 'form-text text-success';
        submitBtn.disabled = false;
    } else {
        matchText.textContent = 'Passwords do not match!';
        matchText.className = 'form-text text-danger';
        submitBtn.disabled = true;
    }
}
</script>

<?php include '../includes/footer.php'; ?>