<?php
session_start();
require 'db.php';
if (!isset($_SESSION['admin_id'])) { header("Location: admin_login.php"); exit; }

// Handle Add Driver
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
    $pdo->prepare("INSERT INTO drivers (name, phone, area_id, username, password_hash, stock) VALUES (?,?,?,?,?,?)")
        ->execute([$_POST['name'], $_POST['phone'], $_POST['area_id'], $_POST['username'], $pass, (int)$_POST['stock']]);
    header("Location: admin_drivers.php");
    exit;
}

// Fetch drivers & areas
$drivers = $pdo->query("SELECT d.*, a.name AS area_name 
                        FROM drivers d 
                        LEFT JOIN areas a ON d.area_id=a.id 
                        ORDER BY d.id DESC")->fetchAll(PDO::FETCH_ASSOC);
$areas = $pdo->query("SELECT * FROM areas")->fetchAll(PDO::FETCH_ASSOC);

// Fetch orders count per driver
$ordersCountStmt = $pdo->query("SELECT driver_id, COUNT(*) AS total_orders FROM orders GROUP BY driver_id")->fetchAll(PDO::FETCH_KEY_PAIR);
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Manage Drivers</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <style>
    .high-empty { color: red; font-weight: bold; }
  </style>
</head>
<body>
  <div class="header">
    <div class="header-inner container">
      <div class="brand"><div class="logo"></div><h1>Drivers</h1></div>
      <a class="btn secondary" href="admin_panel.php">Dashboard</a>
    </div>
  </div>

  <main class="container">
    <!-- Add Driver -->
    <div class="card">
      <h2>Add Driver</h2>
      <div class="hr"></div>
      <form method="post" class="grid grid-2">
        <div><label>Name</label><input class="input" name="name" required></div>
        <div><label>Phone</label><input class="input" name="phone"></div>
        <div><label>Username</label><input class="input" name="username" required></div>
        <div><label>Password</label><input class="input" type="password" name="password" required></div>
        <div>
          <label>Area</label>
          <select class="input" name="area_id">
            <?php foreach($areas as $a): ?>
              <option value="<?php echo $a['id']; ?>"><?php echo htmlspecialchars($a['name']); ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div><label>Starting Stock</label><input class="input" type="number" name="stock" value="0"></div>
        <div style="grid-column:1 / -1"><button class="btn" type="submit">Add Driver</button></div>
      </form>
    </div>

    <!-- Drivers List -->
    <div class="card" style="margin-top:16px">
      <h2>Drivers List</h2>
      <div class="hr"></div>
      <table class="table">
        <thead>
          <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Phone</th>
            <th>Area</th>
            <th>Username</th>
            <th>Main Stock</th>
            <th>Empty</th>
            <th>Sold</th>
            <th>Orders</th>
            <th>Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($drivers as $d): ?>
            <tr>
              <td><?php echo $d['id']; ?></td>
              <td><?php echo htmlspecialchars($d['name']); ?></td>
              <td><?php echo htmlspecialchars($d['phone']); ?></td>
              <td><?php echo htmlspecialchars($d['area_name']); ?></td>
              <td><?php echo htmlspecialchars($d['username']); ?></td>
              <td><?php echo (int)$d['stock']; ?></td>
              <td class="<?php echo ($d['empty_stock'] > 5) ? 'high-empty' : ''; ?>">
                  <?php echo (int)$d['empty_stock']; ?>
              </td>
              <td><?php echo (int)$d['sold']; ?></td>
              <td><?php echo isset($ordersCountStmt[$d['id']]) ? $ordersCountStmt[$d['id']] : 0; ?></td>
              <td>
                <a class="btn small" href="admin_edit_driver.php?id=<?php echo $d['id']; ?>">Edit</a>
                <a class="btn small danger" href="admin_delete_driver.php?id=<?php echo $d['id']; ?>" onclick="return confirm('Delete this driver?');">Delete</a>
              </td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </main>

  <div class="footer">© <?php echo date('Y'); ?> Propane Service</div>
</body>
</html>
