<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
session_start();

require 'db.php';
if (!isset($_SESSION['admin_id'])) { header("Location: admin_login.php"); exit; }

$id = (int)$_GET['id'];
$stmt = $pdo->prepare("SELECT * FROM drivers WHERE id=?");
$stmt->execute([$id]);
$driver = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$driver) {
    die("Driver not found");
}

$areas = $pdo->query("SELECT * FROM areas")->fetchAll(PDO::FETCH_ASSOC);

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $username = $_POST['username'];
    $stock = (int)$_POST['stock'];
    $area_id = $_POST['area_id'];
    
    if (!empty($_POST['password'])) {
        $pass = password_hash($_POST['password'], PASSWORD_DEFAULT);
        $sql = "UPDATE drivers SET name=?, phone=?, username=?, password_hash=?, stock=?, area_id=? WHERE id=?";
        $pdo->prepare($sql)->execute([$name,$phone,$username,$pass,$stock,$area_id,$id]);
    } else {
        $sql = "UPDATE drivers SET name=?, phone=?, username=?, stock=?, area_id=? WHERE id=?";
        $pdo->prepare($sql)->execute([$name,$phone,$username,$stock,$area_id,$id]);
    }

    header("Location: admin_drivers.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Edit Driver</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <style>
    body { background:#0f172a; color:#e2e8f0; font-family:system-ui, sans-serif; margin:0; }
    .container { max-width:800px; margin:auto; padding:16px; }
    .header { display:flex; align-items:center; background:#1e293b; padding:12px 16px; box-shadow:0 2px 8px rgba(0,0,0,.4);}
    .brand { display:flex; align-items:center; gap:10px; }
    .logo { width:32px; height:32px; border-radius:8px; background:linear-gradient(135deg,#3b82f6,#1d4ed8); }
    h1 { margin:0; font-weight:600; }
    .card { background:#1e293b; border-radius:16px; padding:20px; box-shadow:0 6px 16px rgba(0,0,0,.4); margin-top:20px;}
    .input { width:100%; padding:10px; border-radius:8px; border:1px solid #334155; background:#0f172a; color:#e2e8f0; }
    .btn { background:#3b82f6; border:none; color:#fff; padding:10px 16px; border-radius:8px; cursor:pointer; transition:.3s; text-decoration:none; display:inline-block; }
    .btn:hover { background:#2563eb; }
    .btn.secondary { background:#475569; }
    .grid { display:grid; grid-template-columns:repeat(2,1fr); gap:16px; }
    .grid label { display:block; margin-bottom:6px; color:#cbd5e1; font-size:14px; }
  </style>
</head>
<body>
  <div class="header">
    <div class="header-inner container" style="display:flex;justify-content:space-between;align-items:center;">
      <div class="brand"><div class="logo"></div><h1>Edit Driver</h1></div>
      <a class="btn secondary" href="admin_drivers.php">Back</a>
    </div>
  </div>

  <main class="container">
    <div class="card">
      <form method="post" class="grid">
        <div>
          <label>Name</label>
          <input class="input" name="name" value="<?php echo htmlspecialchars($driver['name']); ?>" required>
        </div>
        <div>
          <label>Phone</label>
          <input class="input" name="phone" value="<?php echo htmlspecialchars($driver['phone']); ?>">
        </div>
        <div>
          <label>Username</label>
          <input class="input" name="username" value="<?php echo htmlspecialchars($driver['username']); ?>" required>
        </div>
        <div>
          <label>New Password</label>
          <input class="input" type="password" name="password" placeholder="Leave blank to keep current">
        </div>
        <div>
          <label>Area</label>
          <select class="input" name="area_id">
            <?php foreach($areas as $a): ?>
              <option value="<?php echo $a['id']; ?>" <?php if($a['id']==$driver['area_id']) echo "selected"; ?>>
                <?php echo htmlspecialchars($a['name']); ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label>Stock</label>
          <input class="input" type="number" name="stock" value="<?php echo (int)$driver['stock']; ?>">
        </div>
        <div style="grid-column:1 / -1; text-align:right;">
          <button class="btn" type="submit">Update Driver</button>
        </div>
      </form>
    </div>
  </main>
</body>
</html>
