<?php
session_start();
require 'db.php';
if (!isset($_SESSION['admin_id'])) { header("Location: admin_login.php"); exit; }

$orders = $pdo->query("SELECT o.*, u.name AS user_name, d.name AS driver_name, a.name AS area_name 
                       FROM orders o 
                       JOIN users u ON o.user_id=u.id 
                       LEFT JOIN drivers d ON o.driver_id=d.id 
                       LEFT JOIN areas a ON o.area_id=a.id 
                       ORDER BY o.created_at DESC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <title>Orders — Admin</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <meta http-equiv="refresh" content="8">
</head>
<body>
  <div class="header">
    <div class="header-inner container">
      <div class="brand"><div class="logo"></div><h1>Admin — Orders</h1></div>
      <a class="btn secondary" href="admin_panel.php">Dashboard</a>
    </div>
  </div>
  <main class="container">
    <div class="card">
      <h1>All Orders</h1>
      <div class="hr"></div>
      <table class="table">
        <thead><tr><th>ID</th><th>User</th><th>Area</th><th>Driver</th><th>Status</th><th>Date</th></tr></thead>
        <tbody>
        <?php foreach($orders as $o): ?>
          <tr>
            <td>#<?php echo $o['id']; ?></td>
            <td><?php echo htmlspecialchars($o['user_name']); ?></td>
            <td><?php echo htmlspecialchars($o['area_name']); ?></td>
            <td><?php echo htmlspecialchars($o['driver_name'] ?? '-'); ?></td>
            <td><span class="badge <?php echo $o['status']; ?>"><?php echo $o['status']; ?></span></td>
            <td><?php echo $o['created_at']; ?></td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </main>
  <div class="footer">© <?php echo date('Y'); ?> Propane Service</div>
</body>
</html>