<?php
session_start();
require 'db.php';
if (!isset($_SESSION['admin_id'])) { header("Location: admin_login.php"); exit; }

// Fetch summary stats
$summary = $pdo->query("SELECT 
    COUNT(*) AS total_drivers,
    SUM(stock) AS total_stock,
    SUM(sold) AS total_sold,
    SUM(empty_stock) AS total_empty
FROM drivers")->fetch(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Admin Panel</title>
  <link rel="stylesheet" href="assets/css/styles.css">
  <style>
    body { background:#0f172a; color:#e2e8f0; font-family:system-ui,sans-serif; margin:0; }
    .container { max-width:1100px; margin:40px auto; padding:0 20px; }
    .header { background:#1e293b; padding:16px 0; box-shadow:0 2px 8px rgba(0,0,0,.5); }
    .header-inner { display:flex; justify-content:space-between; align-items:center; }
    .brand { display:flex; align-items:center; gap:10px; }
    .brand h1 { font-size:20px; margin:0; font-weight:600; color:#fff; }
    .btn { display:inline-block; padding:10px 16px; border-radius:8px; font-size:14px; font-weight:500; cursor:pointer; border:none; text-decoration:none; transition:.3s; }
    .btn.secondary { background:#334155; color:#e2e8f0; }
    .btn.secondary:hover { background:#475569; }
    .card { background:#1e293b; border-radius:16px; padding:24px; margin-bottom:20px; box-shadow:0 6px 16px rgba(0,0,0,.4); }
    h2 { margin-top:0; font-size:18px; font-weight:600; }
    .hr { border-bottom:1px solid #334155; margin:12px 0 20px; }
    .grid { display:grid; gap:16px; }
    .grid-2 { grid-template-columns:repeat(2,1fr); }
    .grid-4 { grid-template-columns:repeat(4,1fr); }
    .summary-box { background:#0f172a; padding:16px; border-radius:12px; text-align:center; box-shadow:inset 0 0 6px rgba(0,0,0,.3); }
    .summary-box h3 { font-size:14px; font-weight:500; margin:0 0 6px; color:#cbd5e1; }
    .summary-box div { font-size:18px; font-weight:600; color:#fff; }
    ul { list-style:none; padding:0; margin:0; display:flex; flex-direction:column; gap:10px; }
    li .btn.secondary { width:100%; text-align:center; }
    .muted { color:#94a3b8; font-size:14px; }
    .footer { text-align:center; font-size:13px; color:#94a3b8; margin:20px 0; }
  </style>
</head>
<body>
  <div class="header">
    <div class="header-inner container">
      <div class="brand"><div class="logo"></div><h1>Admin Dashboard</h1></div>
      <a class="btn secondary" href="admin_login.php?logout=1">Logout</a>
    </div>
  </div>

  <main class="container grid grid-2">
    <!-- Summary Section -->
    <div class="card">
      <h2>Drivers Summary</h2>
      <div class="hr"></div>
      <div class="grid grid-4">
        <div class="summary-box">
          <h3>Total Drivers</h3>
          <div><?php echo (int)$summary['total_drivers']; ?></div>
        </div>
        <div class="summary-box">
          <h3>Total Stock</h3>
          <div><?php echo (int)$summary['total_stock']; ?></div>
        </div>
        <div class="summary-box">
          <h3>Total Sold</h3>
          <div><?php echo (int)$summary['total_sold']; ?></div>
        </div>
        <div class="summary-box">
          <h3>Total Empty</h3>
          <div><?php echo (int)$summary['total_empty']; ?></div>
        </div>
      </div>
    </div>

    <!-- Manage Section -->
    <div class="card">
      <h2>Manage</h2>
      <div class="hr"></div>
      <ul>
        <li><a class="btn secondary" href="admin_areas.php">Areas</a></li>
        <li><a class="btn secondary" href="admin_drivers.php">Drivers</a></li>
        <li><a class="btn secondary" href="admin_orders.php">Orders</a></li>
      </ul>
    </div>

    <!-- Tips Section -->
    <div class="card" style="grid-column: span 2;">
      <h2>Tips</h2>
      <div class="hr"></div>
      <p class="muted">Create areas first, then add drivers assigned to an area.</p>
    </div>
  </main>

  <div class="footer">© <?php echo date('Y'); ?> Propane Service</div>
</body>
</html>
