<?php
session_start();
require 'db.php';

// If user already logged in, redirect to index
if (isset($_SESSION['user_id'])) {
    header("Location: index.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Hash the password before storing
    $hashed_password = password_hash($_POST['password'], PASSWORD_BCRYPT);

    $stmt = $pdo->prepare("INSERT INTO users (name, phone, password, address, area_id, gps_lat, gps_lng) 
                           VALUES (?,?,?,?,?,?,?)");
    $stmt->execute([
        $_POST['name'],
        $_POST['phone'],
        $hashed_password,
        $_POST['address'],
        $_POST['area_id'],
        $_POST['gps_lat'],
        $_POST['gps_lng']
    ]);

    $_SESSION['user_id'] = $pdo->lastInsertId();
    header("Location: index.php");
    exit;
}

$areas = $pdo->query("SELECT * FROM areas")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Create Profile — Propane</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="assets/css/styles.css">
  <script defer src="assets/js/app.js"></script>
  <style>
    body { background:#0f172a; color:#e2e8f0; font-family:system-ui, sans-serif; margin:0; }
    .container { max-width:600px; margin:auto; padding:16px; }
    .header { display:flex; align-items:center; background:#1e293b; padding:12px 16px; box-shadow:0 2px 8px rgba(0,0,0,.4);}
    .brand { display:flex; align-items:center; gap:10px; }
    .logo { width:32px; height:32px; border-radius:8px; background:linear-gradient(135deg,#3b82f6,#1d4ed8); }
    h1 { margin:0; font-size:18px; font-weight:600; }
    .card { background:#1e293b; border-radius:16px; padding:20px; box-shadow:0 6px 16px rgba(0,0,0,.4); margin-top:16px;}
    .hr { height:1px; background:linear-gradient(90deg,transparent,rgba(148,163,184,.2),transparent); margin:14px 0;}
    label { font-size:14px; display:block; margin-bottom:4px; }
    .input { width:100%; padding:10px; border-radius:8px; border:1px solid #334155; background:#0f172a; color:#e2e8f0; }
    .btn { background:#3b82f6; border:none; color:#fff; padding:10px 16px; border-radius:8px; cursor:pointer; transition:.3s; }
    .btn:hover { background:#2563eb; }
    .btn.block { width:100%; }
    .muted { color:#94a3b8; font-size:14px; }
    form.grid { display:grid; grid-template-columns:1fr 1fr; gap:16px; }
    .footer { text-align:center; color:#94a3b8; font-size:13px; padding:18px; }
  </style>
</head>
<body>
  <div class="header">
    <div class="brand"><div class="logo"></div><h1>Propane Service</h1></div>
  </div>

  <main class="container">
    <div class="card">
      <h1>Create your profile</h1>
      <p class="muted">We’ll use your area + GPS to route orders to the right driver.</p>
      <div class="hr"></div>
      <form method="post" class="grid grid-2">
        <div>
          <label>Name</label>
          <input class="input" type="text" name="name" required>
        </div>
        <div>
          <label>Phone</label>
          <input class="input" type="text" name="phone" required>
        </div>
        <div>
          <label>Password</label>
          <input class="input" type="password" name="password" required>
        </div>
        <div>
          <label>Address</label>
          <input class="input" type="text" name="address">
        </div>
        <div>
          <label>Area</label>
          <select class="input" name="area_id">
            <?php foreach($areas as $a): ?>
              <option value="<?php echo $a['id']; ?>"><?php echo htmlspecialchars($a['name']); ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div>
          <label>GPS Latitude</label>
          <input id="gps_lat" class="input" type="text" name="gps_lat" placeholder="Click 'Use my location'">
        </div>
        <div>
          <label>GPS Longitude</label>
          <input id="gps_lng" class="input" type="text" name="gps_lng" placeholder="Click 'Use my location'">
        </div>
        <div style="grid-column:1 / -1; display:flex; gap:10px; align-items:center">
          <button class="btn" type="button" onclick="getGPSInto('#gps_lat','#gps_lng','#gps_status')">Use my location</button>
          <span id="gps_status" class="muted"></span>
        </div>
        <div style="grid-column:1 / -1">
          <button class="btn block" type="submit">Save Profile</button>
        </div>
      </form>
    </div>
  </main>

  <div class="footer">© <?php echo date('Y'); ?> Propane Service</div>
</body>
</html>
