<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: user_profile.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$message = '';

// Handle order
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $stmt = $pdo->prepare("INSERT INTO orders (user_id, area_id, qty)
                           SELECT id, area_id, 1 FROM users WHERE id = ?");
    $stmt->execute([$user_id]);

    $_SESSION['flash_message'] = "✅ Your order has been placed!";
    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}

if (isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <title>Propane — Order</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    :root {
      --bg: #0f172a;
      --card: #1e293b;
      --text: #e2e8f0;
      --muted: #94a3b8;
      --primary: #3b82f6;
      --primary-dark: #1d4ed8;
      --success: #16a34a;
    }
    body {
      margin: 0;
      font-family: system-ui,sans-serif;
      background: var(--bg);
      color: var(--text);
      line-height: 1.5;
    }
    .header { background:#1e293b; color:#fff; padding:12px 16px; display:flex; justify-content:space-between; align-items:center; flex-wrap:wrap; position:sticky; top:0; z-index:50; box-shadow:0 2px 8px rgba(0,0,0,0.4); }
    .brand { display:flex; align-items:center; gap:10px; flex:1; }
    .brand .logo { width:32px; height:32px; border-radius:8px; background:linear-gradient(135deg,var(--primary),var(--primary-dark)); box-shadow:0 4px 12px rgba(0,0,0,0.3); animation:float 3s ease-in-out infinite; }
    @keyframes float { 0%,100% { transform: translateY(0); } 50% { transform: translateY(-3px); } }
    .brand h1 { font-size:16px; margin:0; font-weight:600; }
    .nav a { color:#fff; text-decoration:none; margin-left:12px; font-size:14px; transition:color 0.3s; }
    .nav a:hover { color: var(--primary); }
    main { padding:16px; max-width:600px; margin:auto; display:grid; gap:20px; }
    .card { background:var(--card); padding:20px; border-radius:16px; box-shadow:0 6px 16px rgba(0,0,0,0.4); transition: transform 0.3s ease, box-shadow 0.3s ease; }
    .card:hover { transform: translateY(-3px); box-shadow:0 12px 28px rgba(0,0,0,0.5); }
    h1 { font-size:20px; margin:0 0 8px; }
    h2 { font-size:16px; margin:0 0 8px; color: var(--muted); }
    p { font-size:14px; margin:0; color: var(--muted); }
    button img { width:100%; max-width:220px; border-radius:14px; box-shadow:0 4px 12px rgba(0,0,0,0.3); transition: transform 0.2s ease, box-shadow 0.2s ease; }
    button img:hover { transform: scale(1.05); box-shadow:0 8px 20px rgba(0,0,0,0.5); }
    .flash { background: var(--success); color:#fff; padding:10px 14px; border-radius:8px; font-size:14px; margin:0 0 14px; text-align:center; animation:fadeIn 0.6s ease; }
    @keyframes fadeIn { from { opacity:0; transform:translateY(-5px); } to { opacity:1; transform:translateY(0); } }
    ul { margin:0; padding-left:20px; }
    li { margin-bottom:8px; color: var(--text); font-size:14px; }
    .footer { text-align:center; color:var(--muted); font-size:13px; padding:18px; }

    /* Popup Modal */
    #confirmPopup { display:none; position:fixed; top:0; left:0; width:100%; height:100%; background:rgba(0,0,0,0.6); justify-content:center; align-items:center; z-index:1000; }
    #confirmPopup .popup-content { background:var(--card); padding:24px; border-radius:16px; text-align:center; box-shadow:0 6px 16px rgba(0,0,0,0.5); }
    #confirmPopup button { margin:8px; padding:10px 20px; border:none; border-radius:8px; font-size:16px; cursor:pointer; }
    #confirmPopup .confirm { background:var(--success); color:#fff; }
    #confirmPopup .cancel { background:#dc2626; color:#fff; }

    @media (max-width:600px) { .brand h1 { font-size:14px; } .nav a { font-size:13px; margin-left:8px; } .card { padding:16px; } h1 { font-size:18px; } }
  </style>
</head>
<body>

<!-- Header -->
<div class="header">
  <div class="brand">
    <div class="logo"></div>
    <h1>Propane Service</h1>
  </div>
  <div class="nav">
    <a href="user_profile.php">Profile</a>
    <a href="order_status.php">My Orders</a>
  </div>
</div>

<main>
  <!-- Order Card -->
  <section class="card">
    <h1>Order a Propane Bottle</h1>
    <hr style="border:none;border-top:1px solid rgba(255,255,255,0.1);margin:12px 0;">
    <?php if($message): ?>
      <p class="flash"><?php echo htmlspecialchars($message); ?></p>
    <?php endif; ?>
    <form id="orderForm" method="post" style="text-align:center;margin-top:10px;">
      <button type="button" id="orderBtn" style="border:none;background:none;padding:0;cursor:pointer;">
        <img src="./propane.png" alt="Order Propane">
      </button>
    </form>
  </section>

  <!-- How it Works -->
  <section class="card">
    <h2>How it works</h2>
    <ul>
      <li>Tap order → drivers in your area see it.</li>
      <li>First driver to accept will deliver.</li>
      <li>Track progress on the status page.</li>
    </ul>
  </section>
</main>

<!-- Confirmation Popup -->
<div id="confirmPopup">
  <div class="popup-content">
    <p>Are you sure you want to order a propane bottle?</p>
    <button class="confirm" id="confirmYes">✅ Yes</button>
    <button class="cancel" id="confirmNo">❌ No</button>
  </div>
</div>

<div class="footer">© <?php echo date('Y'); ?> Propane Service</div>

<script>
  const orderBtn = document.getElementById('orderBtn');
  const popup = document.getElementById('confirmPopup');
  const confirmYes = document.getElementById('confirmYes');
  const confirmNo = document.getElementById('confirmNo');
  const orderForm = document.getElementById('orderForm');

  orderBtn.addEventListener('click', () => {
    popup.style.display = 'flex';
  });

  confirmNo.addEventListener('click', () => {
    popup.style.display = 'none';
  });

  confirmYes.addEventListener('click', () => {
    popup.style.display = 'none';
    orderForm.submit();
  });
</script>

</body>
</html>
